$(function () {	
   	$('#toolCuotaAA').tooltip({
		title: 'Cuota a pagar'		
	});
	$('#toolDisponAA').tooltip({
		title: 'Saldo disponible que tiene actualmente'
	});
	$('#toolCuotaNC').tooltip({
		title: 'Clic en el vinculo para ver los seguimientos'
	});
	$('#toolCuotaPA').tooltip({
        title: 'Clic en cada uno de los items para ver los seguimientos'
    });
	$('#toolCuotaPC').tooltip({
        title: 'Porcentaje de cumplimiento del crédito',
		tooltipClass: 'tooltip'
    });
});

var cantidadDePaginasAVisualizar=5;

angular.module("ModelSaldos",["ngTable","ngAnimate"])
	.controller("controllerAportesAhorros",
		function($scope,$http,$interval,$serviceSaldos){
			ctrAportesAhorros($scope,$http,$interval,$serviceSaldos)
		})
	.controller("ctrCreditos",
		function($scope,$http,$interval,$serviceSaldos){
			ctrCreditos($scope,$http,$interval,$serviceSaldos)
		})
	.controller("ctrCuotasVarias",
		function($scope,$http,$interval,$serviceSaldos){
			ctrCuotasVarias($scope,$http,$interval,$serviceSaldos)
		})
	.controller("ctrCuotasExtras",
		function($scope,$http,$interval,$serviceSaldos){
			ctrCuotasExtras($scope,$http,$interval,$serviceSaldos)
		})
	.controller("ctrCodeudorDe",
		function($scope,$http,$interval,$serviceSaldos){
			ctrCodeudorDe($scope,$http,$interval,$serviceSaldos)
		})
	.controller("ctrCodeudores",
		function($scope,$http,$interval,$serviceSaldos){
			ctrCodeudores($scope,$http,$interval,$serviceSaldos)
		})
	.factory("$serviceSaldos",["$http",function($http){
		//Tiempo minimo(milisegundos) para mostrar el gif de cargando
		var timeMinLoad=500;
		//Pila para controlar el cargando de la pagina
		var stackLoad=[];
		//Objeto que proporciona las funciones para el control de la pagina
		var obj={
			//valida la data devuelta de cada consulta al servidor
			checkData:function(data){
				try{
					//Comprueba que la data sea valida
					if(data==undefined || data==false )throw 'Error en la data';
					//Comprueba el codigo de estado del servidor
					if(data.status!=200)throw 'Error en la solicitud';
					//Comprueba si el servicio retornó algun mensaje de error
					if(data.data.message!=null)throw data.data.message;
					
					return true;
				}
				catch(err){
					salidaSegura();
					return false;
				}
			},
			//Obtener el tiempo minimo para mostrar el gif
			getTimeMinLoad:function(){
				return timeMinLoad;
			},
			//Manejador de la carga de saldos, para saber que todas los productos se cargaron correctamente
			handleLoadPag:function(){
				
			},
			//Funcion que realiza la peticion al servidor
			ajax:function(data,handle){				
				stackLoad.push(data);
				CargandoMostrar();

				$http({
					method:"POST",
					url:"controlador/ctr_saldos.php",
					header:{
						'Content-Type':'application/json'
					},
					data:data
				})
				.then(
					function success(response){						
						try{
							obj.checkData(response)
							if(!handle(response))throw 'Error mostrando los datos';
						}
						catch(err){
							//cerrarCargando();
						}
						finally{
							stackLoad.pop();						
							if(stackLoad.length<=0){
								cerrarCargando();
							}		
						}				
					},
					function error(){
						cerrarCargando();			
					}
				);		
			}
		}
		return obj;		 	
	}]);
	
/*
Controla que la paginacion no se salga del rango de los datos a mostrar
	pag:pagina que se quiere consultar
	totalPaginas:tamaño vector que tiene todas las paginas
*/
function controllPageRank(pag,totalPaginas){
	//Pagina en la que debe quedar la paginacion
	var pagActual;
	if(pag==0){			
		pagActual=1;
	}
	else if(totalPaginas>0 && pag>totalPaginas){
		pagActual=totalPaginas;
	}
	else{
		pagActual=pag;		
	}
	return pagActual;
}	

function createPagination(pagFirst,pagFast,vecPagination){
	for(var i=pagFirst;i<=pagFast;i++){
		vecPagination.push({class:"",num:i});		
	}
}	

function ctrAportesAhorros($scope,$http,$interval,$serviceSaldos){
	$scope.slide="div-desplegar";						
	$scope.glyphicon="glyphicon glyphicon-minus";
	
	//Guarda las paginas de los aportes y ahorros
	$scope.arrayPaginas=[];

	//Guarda los aportes y los ahorros
	$scope.aportesAhorros=[];

	//Guarda el seguimiento del aporte o ahorro consultado
	$scope.seguiAporAhor=[];

	//Guarda un objeto de las paginas del seguimiento de aportes y ahorros llevando control de la pagina actual
	$scope.seguiPaginas=[];

	//Totales de los productos
	$scope.totalCuotas=0;
	$scope.totalSaldos=0;
	$scope.totalInteres=0;

	//Control del gif de cargando para productos
	$scope.loading=false;

	//Control del gif de cargando para seguimientos
	$scope.loadingSegui=false;

	//Pagina actual en la que se encuentran los productos
	$scope.pagActual=1;
	
	//Pagina actual en la que se encuentran los seguimientos
	$scope.pagActualSegui;
	
	//Funcion que consulta aportes y ahorros		
	$scope.fnAportesAhorros=function(pag,dedonde){
		//Mostrar cargando 
		$scope.loading=true;
		//Control de paginacion		
		pag=controllPageRank(pag,$scope.arrayPaginas.length);
		//Modificar Pagina actual
		$scope.pagActual=pag;			

		//Se consultan aportes y ahorros
		$serviceSaldos.ajax(
			{
				"caso":"1",
				"pag":pag
			},
			function(response){
				try{								
					var data=$scope.organizeData(response.data[0]);
					$scope.aportesAhorros=data;
					$scope.bloquePrincipal='mostrar'
					$scope.bloqueAuxiliar='ocultar'					
					if(dedonde=="crearPaginacion"){						
						$scope.pagInicial=1;
						$scope.pagFinal=numeroPaginas(response.data[1][0].TotalAportesAhorros,10);
						$scope.tfootHidden=$scope.pagFinal<=1?"tfoot-hidden":"";
						createPagination($scope.pagInicial,$scope.pagFinal,$scope.arrayPaginas);
					}
					
					controlPagination($scope.arrayPaginas,pag);
					$interval(function(){$scope.loading=false},$serviceSaldos.getTimeMinLoad(),1);
					return true;
				}
				catch(err){
					$interval(function(){$scope.loading=false},$serviceSaldos.getTimeMinLoad(),1);
					return false;
				}								
			}
		)
	}
	//Se ejecuta funcion para consultar aportes y ahorros
	$scope.fnAportesAhorros(1,"crearPaginacion");	

	//Consulta seguimientos de ahorros y aportes
	$scope.seguimientos=function(nrocuenta,codlinea,pag,dedonde){
			//Mostrar cargando
			$scope.loadingSegui=true;
			//Control de paginacion
			pag=controllPageRank(pag,$scope.seguiPaginas.length);
			//Modificar pagina actual
			$scope.pagActualSegui=pag;
			//Consulta el seguimiento
			$serviceSaldos.ajax(
				{	
					"caso"		:7,
					"pag"		:pag,
					"nrocuenta"	:nrocuenta,
					"codlinea"	:codlinea
				},
				function(response){
					try{
						$serviceSaldos.checkData(response);		
																
						var data=response.data[0]										
						$scope.seguiAporAhor=data;
					
						if(dedonde=="crearPaginacion"){													
							$scope.seguiPagInicial=1;
							$scope.seguiPagFinal=numeroPaginas(response.data[1][0].TotalRegistros,10);
							$scope.tfootSeguiHidden=$scope.seguiPagFinal<=1?"tfoot-hidden":"";			
							$scope.seguiPaginas=[];
							createPagination($scope.seguiPagInicial,$scope.seguiPagFinal,$scope.seguiPaginas);						
							$scope.nrocuenta=nrocuenta;
							$scope.codlinea=codlinea;
						}
																	
						controlPagination($scope.seguiPaginas,pag);
						
						$interval(function(){$scope.loadingSegui=false},$serviceSaldos.getTimeMinLoad(),1);
						return true;
					}
					catch(err){
						$interval(function(){$scope.loadingSegui=false},$serviceSaldos.getTimeMinLoad(),1);
						return false;
					}
				}	
			);
	}
	
	var glyphicon=false;			
	$scope.desplegar=function(nameId){
		var result=deplegarBloques(nameId,glyphicon,$scope.glyphicon,"divAhorrosAportes");
		glyphicon=result.glyphicon;
		$scope.glyphicon=result.glyphiconStyle;
	}
	
	//Procesa los datos
	$scope.organizeData=function(data){
		for(var i in data){
			data[i]["verSeguimiento"]=function(numerocuenta,codlinea,pag,dedonde){				
				$scope.seguimientos(numerocuenta.trim(),codlinea.trim(),pag,dedonde);
			};
			data[i].interes=parseInt(data[i].interes);
			$scope.totalCuotas +=data[i].valorcuota;
			$scope.totalSaldos +=data[i].saldoTotal;
			$scope.totalInteres +=data[i].interes;
		}
		return data;
	}
	
}

function controlPagination(arrayPaginacion,pag){
	try{		
		if(arrayPaginacion.length>cantidadDePaginasAVisualizar){
			for(var i in arrayPaginacion){
				arrayPaginacion[i].class="hidden"
			}
			var aux1,pre,pos,difPre,difPos;
			aux1=parseInt(cantidadDePaginasAVisualizar/2);
			pre=pag-aux1;
			pos=pag+aux1;							
			if(pre<=0){				
				difPre=Math.abs(pre)+1;
				pos=pos+difPre;
				pre=1;
			}							
			if(pos>arrayPaginacion.length){
				difPos=pos-arrayPaginacion.length
				pos=arrayPaginacion.length;
				pre=pre-difPos;								
				if(pre<=0){
					pre=1;
				}	
			}
			for(var k=pre;k<=pos;k++){
				arrayPaginacion[k-1].class="";
			}			
		}
		else{
			for(var i in arrayPaginacion){
				arrayPaginacion[i].class=""
			}			
		}
		if(arrayPaginacion.length>0){
			arrayPaginacion[pag-1].class="active";
		}
	}
	catch(err){
		console.log(err.message);
	}		
}

function ctrCreditos($scope,$http,$interval,$serviceSaldos){
	$scope.slide="div-desplegar";						
	$scope.glyphicon="glyphicon glyphicon-minus";
	
	//Guarda las paginas de creditos
	$scope.arrayPaginas=[];
	//Guarda los productos de credtios
	$scope.productos=[];
	//Guarda las paginas de seguimientos
	$scope.seguiPaginas=[];
	//Guarda las paginas de seguimientos de creditos rotativos
	$scope.seguiPaginasDiscr=[];

	//Totales de los productos
	$scope.totalCuotas=0;
	$scope.totalSaldos=0;

	//Control del gif de cargando para productos 
	$scope.loading=false;

	//Control del gif de cargando para seguimientos
	$scope.loadingSegui=false;

	//Pagina actual en la que se encuentran los productos 
	$scope.pagActual=1;

	//Pagina actual en la que se encuentran los seguimientos
	$scope.pagActualSegui;

	//Funcion que consulta los creditos
	$scope.fnCreditos=function(pag,dedonde){
		//Mostrar cargando 
		$scope.loading=true;
		//Control de paginacion		
		pag=controllPageRank(pag,$scope.arrayPaginas.length);
		//Modificar Pagina actual
		$scope.pagActual=pag;

		//Se consultan aportes y ahorros
		$serviceSaldos.ajax(
			{
				"caso":"2",
				"pag":pag
			},
			function(response){
				try{
					var data=$scope.organizeData(response.data[0]);					
					$scope.productos=data;
					$scope.bloquePrincipal='mostrar'
					$scope.bloqueAuxiliar='ocultar'

					if(dedonde=="crearPaginacion"){				
						$scope.pagInicial=1;
						$scope.pagFinal=numeroPaginas(response.data[1][0].TotalCreditos,10);
						$scope.tfootHidden=$scope.pagFinal<=1?"tfoot-hidden":"";
						createPagination($scope.pagInicial,$scope.pagFinal,$scope.arrayPaginas);
					}
					
					controlPagination($scope.arrayPaginas,pag);
					$interval(function(){$scope.loading=false},$serviceSaldos.getTimeMinLoad(),1);
					return true;
				}
				catch(err){
					$interval(function(){$scope.loading=false},$serviceSaldos.getTimeMinLoad(),1);
					return false;
				}								
			}
		)
	}

	//Se ejecuta funcion para consultar creditos
	$scope.fnCreditos(1,"crearPaginacion");
	
	$scope.organizeData=function(data){
		for(var i in data){
			$scope.totalCuotas +=data[i].anualidad;
			$scope.totalSaldos +=data[i].saldo;
		}
		return data;
	}
	
				
	$scope.seguiODiscriminado=function(pagare,nombre){
		$scope.seguiCreditos=[];		
		if(nombre.toUpperCase().indexOf("ROTATIVO")==-1){
			if(nombre="SEGUIROTA"){
				document.getElementById("modalDiscriRota").style.opacity="0";
			}		
			$("#modalSeguiCredi").modal("show");
			$('#modalSeguiCredi').on('hide.bs.modal', function (e) {
				document.getElementById("modalDiscriRota").style.opacity="1";
			})
			$scope.seguimientos(pagare,1,'crearPaginacion') 
		}
		else{
			$("#modalDiscriRota").modal("show");
			document.getElementById("modalDiscriRota").style.opacity="1";
			$scope.discriminadoRota(pagare,1,'crearPaginacion')
		}		
	};
	
	$scope.seguimientos=function(pagare,pag,dedonde){
		//Mostrar cargando
		$scope.loadingSegui=true;
		//Control de paginacion
		pag=controllPageRank(pag,$scope.seguiPaginas.length);
		//Modificar Pagina actual
		$scope.pagActualSegui=pag;

		$serviceSaldos.ajax(
			{
				"caso":8,
				"pag":pag,
				"pagare":pagare
			},
			function(response){
				try{
					$serviceSaldos.checkData(response)
					
					//Convierte la data en OBJETO JSON
					var xmlDoc=new window.DOMParser().parseFromString(response.data.Seguimientos, "text/xml")
					var raiz=xmlDoc.childNodes[0];
					var lonSegui=raiz.childNodes.length;				
					var json=[];
					for(var i=0;i<lonSegui;i++){
						json.push({
							"pag":raiz.childNodes[i].getElementsByTagName("pag")[0].innerHTML,
							"pagare":raiz.childNodes[i].getElementsByTagName("pagare")[0].innerHTML,
							"fechatrabajo":raiz.childNodes[i].getElementsByTagName("fechatrabajo")[0].innerHTML,
							"detalle":raiz.childNodes[i].getElementsByTagName("detalle")[0].innerHTML,
							"totalefectivo":parseInt(raiz.childNodes[i].getElementsByTagName("totalefectivo")[0].innerHTML)
							})					
					}
					
					$scope.seguiCreditos=json;
					if(dedonde=="crearPaginacion"){
						$scope.seguiPagInicial=1;
						$scope.seguiPagFinal=numeroPaginas(response.data.NumeroSeguimientos,10);
						$scope.tfootSeguiHidden=$scope.seguiPagFinal<=1?"tfoot-hidden":"";
						$scope.seguiPaginas=[];
						createPagination($scope.seguiPagInicial,$scope.seguiPagFinal,$scope.seguiPaginas)
						$scope.pagare=pagare;
					}				
					
					controlPagination($scope.seguiPaginas,pag);
					$interval(function(){$scope.loadingSegui=false},$serviceSaldos.getTimeMinLoad(),1);
					$scope.error=false;
					return true;
				}
				catch(err){
					$scope.error="Percance mostrando la información por favor vuelve a intentar.";
					console.log(err.message);
					$interval(function(){$scope.loadingSegui=false},$serviceSaldos.getTimeMinLoad(),1);
					return false;
				}	
			}
		)		
	}
	$scope.discriminadoRota=function(pagare,pag,dedonde){		
		//Mostrar cargando
		$scope.loadingSegui=true;
		//Control de paginacion
		pag=controllPageRank(pag,$scope.seguiPaginasDiscr.length);
		//Modificar Pagina actual
		$scope.paginaActualSeguiRota=pag;
		//Consulta seguimientos de los rotativos
		$serviceSaldos.ajax(
			{			
				"caso":9,
				"pag":pag,
				"pagare":pagare
			},
			function(response){
				try{
					$serviceSaldos.checkData(response);
											
					var xmlDoc=new window.DOMParser().parseFromString(response.data.PagareHijos, "text/xml")
					var raiz=xmlDoc.childNodes[0];
					var lonSegui=raiz.childNodes.length;				
					var json=[];
					for(var i=0;i<lonSegui;i++){
						json.push({
							"pag":raiz.childNodes[i].getElementsByTagName("pag")[0].innerHTML,
							"NomDes":raiz.childNodes[i].getElementsByTagName("NomDes")[0].innerHTML,
							"pagare":raiz.childNodes[i].getElementsByTagName("pagare")[0].innerHTML,
							"F_iniciofinanciacion":raiz.childNodes[i].getElementsByTagName("F_iniciofinanciacion")[0].innerHTML,
							"plazo":parseInt(raiz.childNodes[i].getElementsByTagName("plazo")[0].innerHTML),
							"F_vence":parseInt(raiz.childNodes[i].getElementsByTagName("F_vence")[0].innerHTML),
							"anualidad":parseInt(raiz.childNodes[i].getElementsByTagName("anualidad")[0].innerHTML),
							"saldo":parseInt(raiz.childNodes[i].getElementsByTagName("saldo")[0].innerHTML),
							"PorCum":parseInt(raiz.childNodes[i].getElementsByTagName("PorCum")[0].innerHTML)
							})					
					}				
					$scope.discriminadoRotativo=json;
					
					if(dedonde=="crearPaginacion"){								
						$scope.seguiPagInicialDiscri=1;
						$scope.seguiPagFinalDiscri=numeroPaginas(response.data.NumeroHijos,10);
						$scope.tfootDiscriHidden=$scope.seguiPagFinalDiscri<=1?"tfoot-hidden":"";			
						$scope.seguiPaginasDiscr=[];
						createPagination($scope.seguiPagInicialDiscri,$scope.seguiPagFinalDiscri,$scope.seguiPaginasDiscr);												
						$scope.pagareRota=pagare;
					}					
					controlPagination($scope.seguiPaginasDiscr,pag);
					$scope.error=false;
					$interval(function(){$scope.loadingSegui=false},$serviceSaldos.getTimeMinLoad(),1);
					return true;
				}
				catch(err){
					$scope.error="Percance mostrando la información por favor vuelve a intentar.";
					$interval(function(){$scope.loadingSegui=false},$serviceSaldos.getTimeMinLoad(),1);
					return false;
				}
			}
		);		
	}	
	var glyphicon=false;			
	$scope.desplegar=function(nameId){
		var result=deplegarBloques(nameId,glyphicon,$scope.glyphicon,"divCreditos");
		glyphicon=result.glyphicon;
		$scope.glyphicon=result.glyphiconStyle;
	}
}


function ctrCuotasVarias($scope,$http,$interval,$serviceSaldos){
	$scope.slide="div-desplegar";						
	$scope.glyphicon="glyphicon glyphicon-minus";
	
	//Guarda las paginas
	$scope.arrayPaginas=[]; 
	//Guarda los productos
	$scope.productos=[];
	//Totales de los productos
	$scope.totalCuotas=0;
	$scope.totalSaldos=0;
	//Control del gif de cargando para productos
	$scope.loading=false;
	//Pagina actual en la que se encuentran los productos
	$scope.pagActual=1;

	//Funcion que consulta las Cuotas Varias
	$scope.fnCuotasVarias=function(pag,dedonde){
		//Mostrar cargando 
		$scope.loading=true;
		//Control de paginacion		
		pag=controllPageRank(pag,$scope.arrayPaginas.length);
		//Modificar Pagina actual
		$scope.pagActual=pag;

		$serviceSaldos.ajax(
			{
				"caso":3,
				"pag":pag
			},
			function(response){
				try{
					var data=$scope.organizeData(response.data[0]);
					$scope.productos=data;

					if(dedonde=="crearPaginacion"){	
						$scope.pagInicial=1;
						$scope.pagFinal=numeroPaginas(response.data[1][0].TotalNovedades,10);
						$scope.tfootHidden=$scope.pagFinal<=1?"tfoot-hidden":"";						
						createPagination($scope.pagInicial,$scope.pagFinal,$scope.arrayPaginas);
					}
					controlPagination($scope.arrayPaginas,pag);
					$interval(function(){$scope.loading=false},$serviceSaldos.getTimeMinLoad(),1);
					return true;	
				}
				catch(err){
					$interval(function(){$scope.loading=false},$serviceSaldos.getTimeMinLoad(),1);
					return false;
				}
			}
		);
	}
	//Se ejecuta funcion para consultar Cuotas Varias
	$scope.fnCuotasVarias(1,"crearPaginacion");
		
	$scope.organizeData=function(data){
		for(var i in data){				
			$scope.totalCuotas +=data[i].cuota;
			$scope.totalSaldos +=data[i].saldo;
		}
		return data;
	}
				
	var glyphicon=false;			
	$scope.desplegar=function(nameId){
		var result=deplegarBloques(nameId,glyphicon,$scope.glyphicon,"divCuotasVarias");
		glyphicon=result.glyphicon;
		$scope.glyphicon=result.glyphiconStyle;
	}

}
function ctrCuotasExtras($scope,$http,$interval,$serviceSaldos){
	$scope.slide="div-desplegar";						
	$scope.glyphicon="glyphicon glyphicon-minus";

	//Guarda las paginas
	$scope.arrayPaginas=[];
	//Guarda los productos
	$scope.productos=[];
	//Control del gif de cargando para productos
	$scope.loading=false;
	//Pagina actual en la que se encuentran los productos
	$scope.pagActual=1;

	$scope.valorFuturo=0;

	//Funcion que consulta las Cuotas Varias
	$scope.fnCuotasExtras=function(pag,dedonde){
		//Mostrar cargando 
		$scope.loading=true;
		//Control de paginacion		
		pag=controllPageRank(pag,$scope.arrayPaginas.length);
		//Modificar Pagina actual
		$scope.pagActual=pag;

		//Consulta las cuotas extras
		$serviceSaldos.ajax(
			{
				"caso":"4",
				"pag":pag
			},
			function(response){
				try{
					var data=$scope.organizeData(response.data[0]);
					$scope.productos=data;

					if(dedonde=="crearPaginacion"){	
						$scope.pagInicial=1;
						$scope.pagFinal=numeroPaginas(response.data[1][0].TotalCuotasExtras,10);
						$scope.tfootHidden=$scope.pagFinal<=1?"tfoot-hidden":"";						
						createPagination($scope.pagInicial,$scope.pagFinal,$scope.arrayPaginas);
					}
					controlPagination($scope.arrayPaginas,pag);
					$interval(function(){$scope.loading=false},$serviceSaldos.getTimeMinLoad(),1);
					return true;
				}
				catch(err){
					console.log(err.message)
					$interval(function(){$scope.loading=false},$serviceSaldos.getTimeMinLoad(),1);
					return false;
				}
			}
		);
	}
	//Se ejecuta funcion para consultar Cuotas extras
	$scope.fnCuotasExtras(1,"crearPaginacion");
	
	$scope.organizeData=function(data){
		for(var i in data){			
			$scope.valorFuturo +=data[i].valorfuturo;
		}
		return data;
	}
			
	var glyphicon=false;			
	$scope.desplegar=function(nameId){
		var result=deplegarBloques(nameId,glyphicon,$scope.glyphicon,"divCuotasExtras");
		glyphicon=result.glyphicon;
		$scope.glyphicon=result.glyphiconStyle;
	}
		
}



function ctrCodeudorDe($scope,$http,$interval,$serviceSaldos){	

	$scope.slide="div-desplegar";						
	$scope.glyphicon="glyphicon glyphicon-minus";
	
	//Guarda las paginas
	$scope.arrayPaginas=[]; 
	//Guarda los productos
	$scope.productos=[];
	//Totales de los productos
	$scope.totalCuotas=0;
	$scope.totalSaldos=0;
	//Control del gif de cargando para productos
	$scope.loading=false;
	//Pagina actual en la que se encuentran los productos
	$scope.pagActual=1;

	//Funcion que consulta de quien soy codeudor
	$scope.fnCodeudorDe=function(pag,dedonde){
		//Mostrar cargando 
		$scope.loading=true;
		//Control de paginacion		
		pag=controllPageRank(pag,$scope.arrayPaginas.length);
		//Modificar Pagina actual
		$scope.pagActual=pag;

		$serviceSaldos.ajax(
			{
				"caso":5,
				"pag":pag
			},
			function(response){
				try{
					var data=$scope.organizeData(response.data[0]);
					$scope.productos=data;				
					
					if(dedonde=="crearPaginacion"){	
						$scope.pagInicial=1;
						$scope.pagFinal=numeroPaginas(response.data[1][0].TotalCodeudorDe,10);
						$scope.tfootHidden=$scope.pagFinal<=1?"tfoot-hidden":"";						
						createPagination($scope.pagInicial,$scope.pagFinal,$scope.arrayPaginas);
					}
					controlPagination($scope.arrayPaginas,pag);
					$interval(function(){$scope.loading=false},$serviceSaldos.getTimeMinLoad(),1);
					return true;	
				}
				catch(err){
					$interval(function(){$scope.loading=false},$serviceSaldos.getTimeMinLoad(),1);
					return false;
				}
			}
		);
	}
	//Se ejecuta funcion para consultar Cuotas Varias
	$scope.fnCodeudorDe(1,"crearPaginacion");
	
	$scope.organizeData=function(data){
		for(var i in data){				
			$scope.totalCuotas +=data[i].anualidad;
			$scope.totalSaldos +=data[i].saldo;
		}
		return data;
	}
				
	var glyphicon=false;			
	$scope.desplegar=function(nameId){
		var result=deplegarBloques(nameId,glyphicon,$scope.glyphicon,"divCodeudorDe");
		glyphicon=result.glyphicon;
		$scope.glyphicon=result.glyphiconStyle;
	}
		
}

function ctrCodeudores($scope,$http,$interval,$serviceSaldos){	
	
	$scope.slide="div-desplegar";						
	$scope.glyphicon="glyphicon glyphicon-minus";
	
	//Guarda las paginas
	$scope.arrayPaginas=[];
	//Guarda los productos
	$scope.productos=[];
	//Control del gif de cargando para productos
	$scope.loading=false;
	//Pagina actual en la que se encuentran los productos
	$scope.pagActual=1;

	$scope.totalCuotas=0;

	//Funcion que consulta los codeudores
	$scope.fnCodeudores=function(pag,dedonde){
		//Mostrar cargando 
		$scope.loading=true;
		//Control de paginacion		
		pag=controllPageRank(pag,$scope.arrayPaginas.length);
		//Modificar Pagina actual
		$scope.pagActual=pag;

		//Consulta los codeudores
		$serviceSaldos.ajax(
			{
				"caso":"6",
				"pag":pag
			},
			function(response){
				try{
					var data=response.data[0];
					$scope.productos=data;
					
					if(dedonde=="crearPaginacion"){	
						$scope.pagInicial=1;
						$scope.pagFinal=numeroPaginas(response.data[1][0].TotalMisCodeudores,10);
						$scope.tfootHidden=$scope.pagFinal<=1?"tfoot-hidden":"";						
						createPagination($scope.pagInicial,$scope.pagFinal,$scope.arrayPaginas);
					}
					controlPagination($scope.arrayPaginas,pag);
					$interval(function(){$scope.loading=false},$serviceSaldos.getTimeMinLoad(),1);
					return true;
				}
				catch(err){
					$interval(function(){$scope.loading=false},$serviceSaldos.getTimeMinLoad(),1);
					return false;
				}
			}
		);
	}
	//Se ejecuta funcion para consultar codeudores
	$scope.fnCodeudores(1,"crearPaginacion");
			
	var glyphicon=false;			
	$scope.desplegar=function(nameId){
		var result=deplegarBloques(nameId,glyphicon,$scope.glyphicon,"divCodeudores");
		glyphicon=result.glyphicon;
		$scope.glyphicon=result.glyphiconStyle;
	}
		
}


function numeroPaginas(totalRegistros,registrosPorPagina){
	if(totalRegistros%registrosPorPagina===0){
		return 	totalRegistros/registrosPorPagina;
	}
	else{
		return 	Math.ceil(totalRegistros/registrosPorPagina);
	}
}

function deplegarBloques(nameId,glyphicon,aux,div){
	var bloque = document.getElementById(nameId);
	if(glyphicon){					
		$("#"+div).css("max-height",bloque.clientHeight+20);
		$("#"+div).css("opacity","1");
		return {"glyphicon":false,"glyphiconStyle":"glyphicon glyphicon-minus"};		
	}
	else{		
		$("#"+div).css("max-height","0px");
		$("#"+div).css("opacity","0");
		return {"glyphicon":true,"glyphiconStyle":"glyphicon glyphicon-chevron-down"};
	}
	
}

String.prototype.trim = function() {
	return this.replace(/^\s*|\s*$/g, '');
}