<?php
require_once dirname(dirname(dirname(__FILE__)))."/modelo/NodeApi.php";
class Informe{
	private $cedula,$pdf,$nodeApi;
	public function Informe($pdf,$cedula){
		$this->cedula=$cedula;
		$this->pdf=$pdf;		
		$this->nodeApi=new NodeApi(false);
	}
	
	public function Cabezote(){
		$infor=$this->nodeApi->privateApi("/Informe/Cabezote",array("cedula"=>$this->cedula),'POST');
		$infor=$infor[0][0];
		$nombres			=trim($infor["primerapellido"]." ".$infor["segundoapellido"]." ".$infor["nombres"]." ".$infor["segundonombre"]);
		$salario			=$infor["salario"];
		$empresa			=trim($infor["empresa"]);
		$empresalabora		=trim($infor["empresalabora"]);
		$fechasistema 		=$infor["fechasistema"];
		$fechatrabajo		=$infor["fechatrabajo"];
		$nombrecompania		=trim($infor["nombrecompania"]); 
		$nombreagencia		=trim($infor["nombreagencia"]);
		$nombredependencia	=$infor["nombredependencia"];
		$fechaingreso		=substr($infor["fechaingreso"],0,10);		
		$encabezado			='
		<table style="font-weight:100;font-size:10;" border="0" cellpadding="1" width="100%">
			<tr>
				<td align="left" colspan="3">
					Fecha Sistema '.date("Y/m/d").'<br />
					Fecha Trabajo '.str_replace("-","/",substr($fechatrabajo,0,10)).'
				</td>
				<td align="right">
					Hora '.date("H:i:s").'<br />
				</td>
			</tr>
			<tr>
				<td align="center" colspan="4">'.$nombrecompania.'--'.$nombreagencia.'<br />INFORME DE ESTADOS DE CUENTA<br /></td>
			</tr>
			<tr>
				<td width="10%" align="left">Cédula:</td>
				<td width="40%" align="left">'.$this->cedula.'</td>
				<td width="10%" align="left">Nombres:</td>
				<td width="40%" align="right">'.$nombres.'</td>
			</tr>
			<tr>
				<td align="left">Empresa:</td>
				<td align="left">'.$empresa.'</td>
				<td align="left">Dependencia:</td>
				<td align="right">'.$nombredependencia.'</td>
			</tr>
			<tr>
				<td align="left">Ingreso:</td>
				<td align="left">'.$fechaingreso.'</td>
				<td align="left">Salario:</td>
				<td align="right">'.number_format($salario).'</td>
			</tr>
		</table>
		<br /><br /><br />
		';
		return $encabezado;		
	}
	public function AportesAhorros($datos){
		if(!$this->ValidarDatos($datos))return;
		$aportesahorros='
			<table cellpadding="2" border="0" width="100%">
				<tr><td colspan="7" style="font-weight:100;font-size:10;text-align:center">APORTES Y AHORROS<br /></td></tr>
				<tr>
					<td width="28%" align="left">Nombre</td>
					<td width="12%" align="left">Cuenta</td>
					<td width="12%" align="left">Apertura</td>
					<td width="12%" align="left">Vencimiento</td>
					<td width="12%" align="right">Cuota</td>
					<td width="12%" align="right">Saldo</td>
					<td width="12%" align="right">Interes</td>
				</tr>			
		';
		for($i=0;$i<count($datos);$i++){
			$aportesahorros.='
				<tr>
					<td align="left">'.trim($datos[$i]["namelinea"]).'</td>
					<td align="left">'.trim($datos[$i]["numerocuenta"]).'</td>
					<td align="left">'.trim(str_replace("-","/",substr($datos[$i]["fechainicio"],0,10))).'</td>
					<td align="left">'.trim(str_replace("-","/",substr($datos[$i]["fechavence"],0,10))).'</td>
					<td align="right">'.trim($datos[$i]["valorcuota"]).'</td>
					<td align="right">'.trim($datos[$i]["saldoTotal"]).'</td>
					<td align="right">'.trim($datos[$i]["interes"]).'</td>
				</tr>';			
		}
		$aportesahorros.='</table><br /><br /><br />';
		return $aportesahorros;		
	}
	public function Creditos($datos){
		if(!$this->ValidarDatos($datos))return;	
		$creditos='
			<table border="0" cellpadding="2" width="100%">
				<tr><td colspan="8" style="font-weight:100;font-size:10;text-align:center">CREDITOS<br /></td></tr>
				<tr>
					<td width="25%" align="left">Nombre</td>
					<td width="10%" align="center">Pagare</td>
					<td width="12%" align="left">Apertura</td>
					<td width="12%" align="left">Vencimiento</td>
					<td width="10%" align="right">Plazo</td>
					<td width="10%" align="right">Cuota</td>
					<td width="11%" align="right">Saldo</td>
					<td width="10%" align="right">PorCum</td>
				</tr>
		';
		for($i=0;$i<count($datos);$i++){
			$creditos .='
			<tr>
				<td align="left">'.trim($datos[$i]["NomDes"]).'</td>
				<td align="center">'.trim($datos[$i]["pagare"]).'</td>
				<td align="left">'.trim(str_replace("-","/",substr($datos[$i]["F_iniciofinanciacion"],0,10))).'</td>
				<td align="left">'.trim(str_replace("-","/",substr($datos[$i]["F_vence"],0,10))).'</td>
				<td align="right">'.trim($datos[$i]["plazo"]).'</td>
				<td align="right">'.number_format(trim($datos[$i]["anualidad"])).'</td>
				<td align="right">'.number_format(trim($datos[$i]["saldo"])).'</td>
				<td align="right">'.trim($datos[$i]["PorCum"]).'</td>
			</tr>';
		}
		$creditos .="</table><br /><br /><br />";
		return $creditos;		
	}
	public function CodeudorDe($datos){
		if(!$this->ValidarDatos($datos))return;
		$codeudoresDe='
			<table cellpadding="2" border="0" width="100%">
				<tr><td colspan="6" style="font-weight:100;font-size:10;text-align:center">CODEUDOR DE<br /></td></tr>
				<tr>
					<td align="left">NOMBRE</td>
					<td align="left">PAGARE</td>
					<td align="left">VENCIMIENTO</td>
					<td align="right">PLAZO</td>
					<td align="right">CUOTA</td>
					<td align="right">SALDO</td>					
				</tr>
			
		';
		for($i=0;$i<count($datos);$i++){
			$codeudoresDe.='
				<tr>
					<td align="left" >'.trim($datos[$i]["nombreintegrado"]).'</td>
					<td align="left">'.trim($datos[$i]["pagare"]).'</td>
					<td align="left">'.str_replace("-","/",substr(trim($datos[$i]["F_vence"]),0,10)).'</td>
					<td align="right">'.trim($datos[$i]["plazo"]).'</td>
					<td align="right">'.number_format(trim($datos[$i]["anualidad"])).'</td>
					<td align="right">'.number_format(trim($datos[$i]["saldo"])).'</td>
				</tr>
			';
		}
		$codeudoresDe.='</table><br /><br /><br />';
		return $codeudoresDe;
	}
	public function Codeudores($datos){
		if(!$this->ValidarDatos($datos))return;
		$codeudores='
			<table cellpadding="2" width="100%" border="0">
				<tr><td colspan="8" style="font-weight:100;font-size:10;text-align:center">CODEUDORES<br /></td></tr>
				<tr>
					<td width="18%" align="left">Cedula</td>
					<td width="28%" align="left">Nombre</td>
					<td width="18%" align="left">Pagare</td>
					<td width="18%" align="left">Direccion</td>
					<td width="18%" align="right">Telefono</td>					
				</tr>
			
		';
		for($i=0;$i<count($datos);$i++){
			$codeudores.='
				<tr>
					<td align="left">'.trim($datos[$i]["cedula"]).'</td>
					<td align="left">'.trim($datos[$i]["nombreintegrado"]).'</td>
					<td align="left">'.trim($datos[$i]["pagare"]).'</td>
					<td align="left">'.trim($datos[$i]["direccion"]).'</td>
					<td align="right">'.trim($datos[$i]["telefono"]).'</td>
					
				</tr>
			';
		}
		$codeudores.='</table><br /><br /><br />';
		return $codeudores;
	}
	
	public function CuotasExtras($datos){
		if(!$this->ValidarDatos($datos))return;
		$cuotasExtras='
			<table cellpadding="2" border="0" width="100%">
				<tr><td colspan="6" style="font-weight:100;font-size:10;text-align:center">CUOTAS EXTRAS<br /></td></tr>
				<tr>
					<td align="left">Pagare</td>
					<td align="left">Fecha Apertura</td>
					<td align="left">Fecha Vencimiento</td>
					<td align="left">Plazo</td>
					<td align="left">Pagado</td>
					<td align="right">Valor</td>
				</tr>
		';		
		for($i=0;$i<count($datos);$i++){
			$cuotasExtras.='
			<tr>
				<td align="left">'.trim($datos[$i]["pagare"]).'</td>
				<td align="left">'.substr(str_replace("-","/",trim($datos[$i]["fechaapertura"])),0,10).'</td>
				<td align="left">'.substr(str_replace("-","/",trim($datos[$i]["fechavence"])),0,10).'</td>
				<td align="left">'.trim($datos[$i]["plazo"]).'</td>
				<td align="left">'.trim($datos[$i]["pagado"]).'</td>
				<td align="right">'.number_format(trim($datos[$i]["valorfuturo"])).'</td>
			</tr>';
		}
		$cuotasExtras.='</table><br /><br /><br />';
		return $cuotasExtras;		
	}
	
	public function NovedadesVarias($datos){
		if(!$this->ValidarDatos($datos))return;		
		$novedadesVarias='
			<table border="0" cellpadding="2" width="100%">
				<tr><td colspan="5" style="font-weight:100;font-size:10;text-align:center">NOVEDADES VARIAS<br /></td></tr>
				<tr>
					<td width="28%" align="left">Concepto</td>
					<td width="18%" align="right">Cuota</td>
					<td width="18%" align="right">Saldo</td>
					<td width="18%" align="right">Cuotas Mora</td>
					<td width="18%" align="right">Morosidad</td>
				</tr>
		';
		for($i=0;$i<count($datos);$i++){
			$novedadesVarias.='
			<tr>
				<td align="left">'.trim($datos[$i]["nomcta"]).'</td>
				<td align="right">'.number_format(trim($datos[$i]["cuota"])).'</td>
				<td align="right">'.number_format(trim($datos[$i]["saldo"])).'</td>
				<td align="right">'.trim($datos[$i]["diasmor"]).'</td>
				<td align="right">'.number_format(trim($datos[$i]["vlrmor"])).'</td>
			</tr>
			';
		}
		$novedadesVarias.="</table><br /><br /><br />";
		return $novedadesVarias;		
	}
	public function ValidarDatos($datos){
		if(is_null($datos))return false;
		if(!is_array($datos)>0)return false;
		if(count($datos)<=0)return false;	
		return true;
	}
}

?>