$(function () {
  	$('body').tooltip({
    	selector: '[rel="tooltip"]'
	});
})

angular
    .module("modProdServ", ["ngRoute"])
    .config(function($routeProvider) {
        $routeProvider
            .when("/", {
                templateUrl: "vista/view_ProductosServicios.html",
                controller: "ctrProductosServicios"
            })
            .otherwise({
                templateUrl: "vista/view_ProductosServicios.html",
                controller: "ctrProductosServicios"
            });
    })
    .factory("$factory", function() {
        var obj = {
            valResp: function(res) {
                try {
                    if (res.status == 404) {
                        //throw { message: "Servicio no encontrado" };
                        /*location.href =
                            "../includes_generales/salida_segura.php";*/
                    }
                    if (res.data.message != undefined) throw res.data;
                    if (res.data.estado != undefined && !res.data.estado)
                        throw { message: res.data.msj };
                    cerrarCargando();
                    return { estado: true };
                } catch (err) {
                    cerrarCargando();
                    return { estado: false, msj: err.message };
                }
            }
        };
        return obj;
    })
    .service("$srvProductosServicios", [
        "$http",
        function($http) {
            this.productosServicios = function() {
                CargandoMostrar();
                return $http({
                    method: "POST",
                    url: "ctr/ctr_ProductosServicios.php",
                    data: { caso: 1 },
                    header: {
                        "Content-Type": "application/json"
                    }
                });
            };
			
			this.Adjuntos = function(datos) {
                //CargandoMostrar();
                return $http({
                    method: "POST",
                    url: "ctr/ctr_ProductosServicios.php",
                    data: datos,
                    header: {
                        "Content-Type": "application/json"
                    }
                });
            };
			
			this.Campos = function(datos) {
                //CargandoMostrar();
                return $http({
                    method: "POST",
                    url: "ctr/ctr_ProductosServicios.php",
                    data: datos,
                    header: {
                        "Content-Type": "application/json"
                    }
                });
            };
			
			this.EstadoSol = function(datos) {
                CargandoMostrar();
                return $http({
                    method: "POST",
                    url: "ctr/ctr_ProductosServicios.php",
                    data: datos,
                    header: {
                        "Content-Type": "application/json"
                    }
                });
            };
			
			this.SeguimientoSol = function(datos) {
                CargandoMostrar();
                return $http({
                    method: "POST",
                    url: "ctr/ctr_ProductosServicios.php",
                    data: datos,
                    header: {
                        "Content-Type": "application/json"
                    }
                });
            };
			
			this.Solicitud = function(datos) {
                CargandoMostrar();
                return $http({
                    method: "POST",
                    url: "ctr/ctr_ProductosServiciosGuardar.php",
                    data: datos,
                    headers: {
                        'Content-Type': undefined
                    },
                });
            };

            this.ValidarNumSolicitudes = function(datos){
            	 CargandoMostrar();
                return $http({
                    method: "POST",
                    url: "ctr/ctr_ProductosServicios.php",
                    data: datos,
                    headers: {
                        'Content-Type': "application/json",
                    },
                });
            }
        }
    ])
    .controller("ctrProductosServicios", [
        "$scope",
        "$srvProductosServicios",
        "$factory",
        function($scope, $srv, $factory) {
            //Productos
            $scope.parametroProdServ = [];
			
			//Adjuntos
            $scope.adjuntos = [];
			
			//Campos Dinamicos
			$scope.campos = [];
			
			//estado de solicitudes
			$scope.estado = [];
			
			//seguimiento de solicitudes
			$scope.seguimiento = [];
			
			//Datos del producto a visualizar
			$scope.producto={};

            //Producto seleccionado
            $scope.parametroSelected;

            //$scope.plazo = 0;

            $scope.response = undefined;

            $srv.productosServicios().then(
                function(res) {
                    var valResp = $factory.valResp(res);
					
                    if (!valResp["estado"]) {
                        $scope.response = valResp;
                    }
                    $scope.response = res.data;
                    if ($scope.response.estado) {
                        $scope.parametroProdServ = $scope.response.data;
                    }
					$scope.EstadoSolicitudes();
                },
                function(err) {
                    $scope.response = $factory.valResp(err);
                }
            );
			
			$scope.ConsultaAdjuntos = function() {
				//console.log($scope.parametroSelected.nombre);
				$("#NomProd").val($scope.parametroSelected.nombre);
				$("#DescProd").html($scope.parametroSelected.descripcion);
				
				var data = {
                    caso:2,
					codigo:$scope.parametroSelected.idtipo
                };
				
				$srv.Adjuntos(data).then(
					function(res) {
						var valResp = $factory.valResp(res);
					
						if (!valResp["estado"]) {
							$scope.response = valResp;
						}
						$scope.response = res.data;
						if ($scope.response.estado) {
							$scope.adjuntos = $scope.response.data;
							if($scope.adjuntos==''){
								$("#ContentAdjuntos").css("display","none");
							}
							$scope.ConsultaCampos();
						}
					},
					function(err) {
						$scope.response = $factory.valResp(err);
					}
				);
			}
			
			$scope.ConsultaCampos = function() {
				var data = {
                    caso:3,
					codigo:$scope.parametroSelected.idtipo
                };
				
				$srv.Campos(data).then(
					function(res) {
						var valResp = $factory.valResp(res);
					
						if (!valResp["estado"]) {
							$scope.response = valResp;
						}
						$scope.response = res.data;
						if ($scope.response.estado) {
							$scope.campos = $scope.response.data;
							if($scope.campos==''){
								$("#ContentCampos").css("display","none");
							}
						}
					},
					function(err) {
						$scope.response = $factory.valResp(err);
					}
				);
			}
			
			$scope.EstadoSolicitudes = function() {
				var data = {
                    caso:4,
                };
				
				$srv.EstadoSol(data).then(
					function(res) {
						var valResp = $factory.valResp(res);
					
						if (!valResp["estado"]) {
							$scope.response = valResp;
						}
						$scope.response = res.data;
						if ($scope.response.estado) {
							$scope.estado = $scope.response.data;
						}
					},
					function(err) {
						$scope.response = $factory.valResp(err);
					}
				);
			}
			
			$scope.Seguimiento = function(data) {
				$scope.producto = data;
				
				var data = {
                    caso:5,
					idSolicitud:$scope.producto.idTabla
                };
				
				$srv.SeguimientoSol(data).then(
					function(res) {
						var valResp = $factory.valResp(res);
						if (!valResp["estado"]) {
							$scope.response = valResp;
						}
						$scope.response = res.data;
						if ($scope.response.estado) {
							$scope.seguimiento = $scope.response.data;
						}
					},
					function(err) {
						$scope.response = $factory.valResp(err);
					}
				);
			}

			$scope.ValidarSolicitud = function(){

				var data = {
                    caso:6,
					codigo:$scope.parametroSelected.idtipo
                };
            	
            	$srv.ValidarNumSolicitudes(data).then(
					function(res) {
						var valResp = $factory.valResp(res);
						if (!valResp["estado"]) {
							$scope.response = valResp;
						}
						$scope.validacion = res.data;
						if($scope.validacion.msj=="SI"){
							Continuar(1);	
						}else{
							alert($scope.validacion.msj);
						}
						
						
					},
					function(err) {
						$scope.response = $factory.valResp(err);
					}
				);
                
			}

            $scope.submit = function() {
				var paqueteDeDatos = new FormData();//funcion propia de javascript para obtener todo los campos y valores del FORM y poder capturar los archivos adjuntos
				
				var cont = 1;
				var data = new Array;
				var json='';
				
				paqueteDeDatos.append("caso",1);
				paqueteDeDatos.append("codigoProd",$scope.parametroSelected.codigo);
				paqueteDeDatos.append("idtipo",$scope.parametroSelected.idtipo);
				paqueteDeDatos.append("contAdjuntos",$scope.adjuntos.length);
				
				for(a=1; a<=$scope.adjuntos.length; a++){
					adjuntos = document.getElementById("btn-adjutos"+a);

					if (adjuntos.files[0].size < 210){
						alert('Error en el tamaño del adjunto, al parecer esta dañado o currupto');
						document.getElementById(adjuntos.id).focus();
						return false;
					}

					paqueteDeDatos.append('adjuntos'+a,adjuntos.files[0]);
					idAdj = document.getElementById("IdAdj"+a).value;
					if(idAdj!=""){
						paqueteDeDatos.append('IdAdj'+a,idAdj);
					}
				}
				//return;
				
				for(i=0; i<$scope.campos.length; i++){
						//HACEMOS VALIDACION DE QUE SI EL PINTO FORMULARIO SIEMPRE DEBA IR UN JSON Y NO VAYA VACIO YA QUE REPORTARON QUE SE ESTABA LLENDO EN LA CONSOLA DE DATOS ADICIONALES VACIO
					//El entrara solamente aqui si pinto formulario
					if(document.getElementById("campo"+cont).value != ''){
						paqueteDeDatos.append('ControlDeJsonVacio',1);
					}
					
					campos = document.getElementById("campo"+cont).value.trim();
					
					var nombreCampo = $scope.campos[i].nombre.trim();
					if(cont==$scope.campos.length){
						var coma = '';
					}
					else{
						var coma = ',';
					}
					
					data[i] = '"'+nombreCampo+'":"'+campos.replaceAll(",", "-")+'"'+coma;
					cont++;
				}
				
				for(x=0; x<data.length; x++){
					json+= data[x];
				}
				json = '{'+json+'}';
				
				paqueteDeDatos.append('ContenidoCampos',json);
				paqueteDeDatos.append('observacion',document.getElementById("ObservacionProd").value);
				
				
				//return;
                if (
                    confirm(
                        "Está seguro de enviar la solicitud?"
                    )
                ) {
                    $srv.Solicitud(paqueteDeDatos).then(
                        function(res) {
                            var valResp = $factory.valResp(res);
                            if (!valResp["estado"]) {
								$scope.response = valResp;
								return;
                            }
                            //$scope.response = res.data;
							if (valResp["estado"] == true)
							{
								alert(res.data.msj);
							}
							
							//window.location = "../saldos"
							$scope.EstadoSolicitudes();
							CargandoMostrar();
							Continuar(3);

                        },
                        function(err) {
                            $scope.response = $factory.valResp(err);
                        }
                    );
                }
            };

            $scope.formatNumero = function() {
                if ($scope.cuota !== undefined) {
                    var aux = $scope.cuota.QuitarCaracter(",");
                    aux = parseInt(aux);
                    $scope.cuota = aux.numberFormat();
                }
            };
        }
    ]);

function Continuar(caso){
	switch(caso){
		case 1:	
			//if(document.getElementById("parametroProductosServicios").checked==false){
			if(document.getElementById("parametroProductosServicios").value==""){
				alert("Debe escoger un producto o servicio");
				document.getElementById("parametroProductosServicios").focus();
				return false;
			}
			
			$("#Parametro").css("display","none");
			$("#Content").show(100);
			$("#msjGeneraSol").css("display","none");
			$("#msjSolicitud").show(100);
			$("#complemento").html(": generar solicitud");
			break;
		
		case 2:
			$("#Seguimiento").css("display","none");
			$("#opciones").css("display","none");
			$("#Solicitud").show(100);
			$("#msjPrimcipal").css("display","none");
			$("#msjGeneraSol").show(100);
			$("#complemento").html(": generar solicitud");
			break;
		
		case 3:
			$("#Solicitud").css("display","none");
			$("#opciones").css("display","none");
			$("#Seguimiento").show(100);
			$("#msjPrimcipal").css("display","none");
			$("#msjGeneraSol").css("display","none");
			$("#msjSolicitud").css("display","none");
			$("#msjVerEstado").show(100);
			$("#complemento").html(": ver estado solicitud");
			break;
	}
}