<?php
require_once dirname(__FILE__)."/../../vendor/autoload.php";
class ProductosServicios{
	
	//Contiene toda la informacion del asociado
	private $objAsociado;	
			
	//Conexion al servicio web
	private $nodeApi;
	
	//Variable que utilizaremos como un array para manejar los mensajes y el estado de proceso ejecutado
	private $response;
	
	
	//Contructor del nuevo ahorro, se le debera enviar la cedula del asociado como parametro
	public function ProductosServicios($cedula){
		$this->response=array("estado"=>true,"msj"=>"");
		$this->fecha=date('Y/m/d H:i:s');
		try{
			$this->objAsociado=new Asociado($cedula);
			//Si hay un error consultando el asociado lanzamos la excepción
			if($this->objAsociado->getError())throw new Exception("No fue posible consultar los datos del asociado");
			
			$this->nodeApi=new NodeApi();			
			//Si hay un error con la conexion al servicio lanzamos la excepción
			if(!$this->nodeApi->__getEstado())throw new Exception("No fue posible consultar los datos del asociado");
			
			$this->response=array("estado"=>true,"msj"=>"Objeto creado correctamente");
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());			
		}		
	}
	
	public function parametroProdServ(){
		try{
			$result=$this->nodeApi->privateApi("/ProdServ/ParametrosProductosServicios",array(),'GET');
			$result=$result[0];
			$tam=count($result);
			$data = array();

			for($i=0; $i<$tam; $i++){
				$result[$i]["nombre"]     = ucfirst($this->fullUpper($result[$i]["nombre"]));				
				$result[$i]["descripcion"]= ucfirst($this->fullLower($result[$i]["descripcion"]));
				$data[]=$result[$i];
			}
			
			$this->response=array("estado"=>true,"data"=>$data);
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}
	
	public function adjuntos($codigo){
		try{
			$result=$this->nodeApi->privateApi("/ProdServ/Adjuntos",array("idProductoServicio"=>$codigo),'GET');
			$result=$result[0];
			
			$tam=count($result);
			$data = array();
			if(!isset($result[0]))throw new Exception("Error consultando adjuntos");
			
			for($i=0; $i<$tam; $i++){
				if(isset($result[0])){
					$result[$i]["descripcion"]= ucfirst($this->fullLower($result[$i]["descripcion"]));
					$result[$i]["NomAdj"]     = ucfirst($this->fullLower($result[$i]["NomAdj"]));
					$data[]=$result[$i];
				}
				else{
					$data[]="";
				}
			}
			//exit;
			$this->response=array("estado"=>true,"data"=>$data);
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}
	
	
	public function CamposDinamicos($codigo){
		try{
			$result = $this->nodeApi->privateApi("/ProdServ/CamposDinamicos",array("idProductoServicio"=>$codigo),'GET');
			$result = $result[0];

			$tam  = count($result);
			$data = array();

			if(!isset($result[0]))throw new Exception("Error consultando campos dinamicos");
			
			for($i=0; $i<$tam; $i++){
				if($result[$i]["existe"]<>NULL and $result[$i]["estadolista"]<>"I") 
				{

					$result[$i]["descripcion"] = ucfirst($this->fullLower($result[$i]["descripcion"]));
					$result[$i]["nombre"]      = ucfirst($this->fullLower($result[$i]["nombre"]));

					if($result[$i]["tipoCampo"]=="C"){
						$result[$i]["tipoCampo"]="text";
					}
					if($result[$i]["tipoCampo"]=="N"){
						$result[$i]["tipoCampo"]="number";
					}
					if($result[$i]["tipoCampo"]=="L"){
						$result[$i]["tipoCampo"]="select";

						$result_Lista = $this->nodeApi->publicApi("/ProdServ/ArmarListasDeCampoDinamico",array("CodigoLista" => $result[$i]["codigolista"]),'GET');
						$result[$i]["contenidoLista"] = $result_Lista[0];
					}
					
					$data[]=$result[$i];
				}
			}

			$this->response=array("estado"=>true,"data"=>$data);
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}
	

	public function GuardarSolicitud($numeroSolicitud,$IdProSer,$ContenidoCamProSer,$NotaAsociado,$Adjuntos){
		try{

			$PuedeSeguirPorControlSolicitudes = 'SI';
			$PuedeSeguirPorControlSolicitudes = $this->ControlarSiContinuaPorNumeroSolicitudes($IdProSer);
			if ($PuedeSeguirPorControlSolicitudes != 'SI')
			{
				throw new Exception($PuedeSeguirPorControlSolicitudes);
			}

			$result=$this->nodeApi->privateApi("/ProdServ/GuardarSolicitud",
				array("numeroSolicitud"=>$numeroSolicitud,
					"Cedula"=>$this->objAsociado->__get('cedulasociado'),
					"IdProSer"=>$IdProSer,
					"ContenidoCamProSer"=>$ContenidoCamProSer,			
					"NotaAsociado"=>$NotaAsociado,
					"Adjuntos"=>$Adjuntos)
			,"POST");
			
			if(count($result)>0)throw new Exception("No fue posible realizar la solicitud");
			
			$this->response=array("estado"=>true,"msj"=>"Tu solicitud ha sido generada con el siguiente número de radicado ".$numeroSolicitud." y enviada a la entidad. Puedes hacerle seguimiento a su estado en la opción 'Ver estado solicitud' del menú Productos/Servicios.");

		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());	
		}		
	}
	
	public function Numsolicitud(){
		try{
			$result=$this->nodeApi->privateApi("/ProdServ/Numsolicitud",array(),'GET');
			$result=$result[0];
			
			//$this->response=array("estado"=>true,"data"=>$result["numeroSolicitud"]);
			return $result["numeroSolicitud"];
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}
	
	public function EstadoSolicitudes(){
		try{
		$result = $this->nodeApi->privateApi("/ProdServ/ConsultarSolicitudes",array("idProductoServicio"=>"","cedula"=>$this->objAsociado->__get('cedulasociado')),'GET');
		$result=$result[0];
		$tam=count($result);
		$data = array();
			//if(!isset($result[0]))throw new Exception("En el momento no hay solicitudes");
			
			for($i=0; $i<$tam; $i++){
				if($result[$i]["EstadoActual"]=='E'){
					$result[$i]["EstadoActual"] = "EN ESTUDIO";
				}
				else if($result[$i]["EstadoActual"]=='T'){
					$result[$i]["EstadoActual"] = "EN TRÁMITE";
				}
				else if($result[$i]["EstadoActual"]=='A'){
					$result[$i]["EstadoActual"] = "APROBADA";
				}
				else if($result[$i]["EstadoActual"]=='N'){
					$result[$i]["EstadoActual"] = "NEGADA";
				}
				else if($result[$i]["EstadoActual"]=='X'){
					$result[$i]["EstadoActual"] = "ANULADA";
				}
				
				$data[]=$result[$i];
			}
			
			$this->response=array("estado"=>true,"data"=>$data);
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}
	
	public function SeguimientoSol($idSolicitud){
		try{
		$result = $this->nodeApi->privateApi("/ProdServ/SeguimientoSol",array("idSolicitud"=>$idSolicitud),'GET');
		$tam=count($result);
		$data = array();
			if(!isset($result[0]))throw new Exception("Error consultando los seguimientos de las solicitudes");
			
			for($i=0; $i<$tam; $i++){
				if($result[$i]["EstadoNuevo"]=='E'){
					$result[$i]["EstadoNuevo"] = "EN ESTUDIO";
				}
				else if($result[$i]["EstadoNuevo"]=='T'){
					$result[$i]["EstadoNuevo"] = "EN TRÁMITE";
				}
				else if($result[$i]["EstadoNuevo"]=='A'){
					$result[$i]["EstadoNuevo"] = "APROBADA";
				}
				else if($result[$i]["EstadoNuevo"]=='N'){
					$result[$i]["EstadoNuevo"] = "NEGADA";
				}
				else if($result[$i]["EstadoNuevo"]=='X'){
					$result[$i]["EstadoNuevo"] = "ANULADA";
				}
				
				$data[]=$result[$i];
			}
			
			$this->response=array("estado"=>true,"data"=>$data);
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}

	public function getResponse(){
		return $this->response;
	}
	
	public function __set($variable,$valor){
		if(property_exists($this,$variable)){
			$this->$variable=$valor;
		}
	}
	
	public function __get($variable){
		if(property_exists($this,$variable)){
			return $this->$variable;
		}
		return NULL;
	}	



	public function daysdiff ($dt1, $dt2){
		$dt1 = new DateTime($dt1);
		$dt2 = new DateTime($dt2);  
		
		/*if ($dt1->diff($dt1)->format("%a")!= '6015') {
			return $dt1->diff($dt2)->format("%a");
		}*/
		
		$y1 = $dt1->format('Y');  
		$y2 = $dt2->format('Y');
		$z1 = $dt1->format('z');
		$z2 = $dt2->format('z');
		
		$diff = intval($y1 * '360' + $z1) - intval($y2 * '360' + $z2);
		
		return $diff;
	}

	public function ArmarListasDeCampoDinamico(){
		try{
			$result = $this->nodeApi->privateApi("/ProdServ/ArmarListasDeCampoDinamico",array(),'GET');
			$result = $result[0];
			$tam    = count($result);
			$data   = array();
			
			if(!isset($result[0]))throw new Exception("Error consultando campos dinamicos");
			
			for($i=0; $i<$tam; $i++){
				$result[$i]["ContenidoDeLaLista"]= $this->fullUpper ($result[$i]["ContenidoDeLaLista"]);
				
				$data[]=$result[$i];
			}
			
			return $data;
		}
		catch(Exception $e){
			return array("estado"=>false,"msj"=>$e->getMessage());
		}
	}

	public function fullLower($str)
	{
		$convert_to = array( 
			//INI: A minusculas todos
				"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", 
				"v", "w", "x", "y", "z", "à", "á", "â", "ã", "ä", "å", "æ", "ç", "è", "é", "ê", "ë", "ì", "í", "î", "ï", 
				"ð", "ñ", "ò", "ó", "ô", "õ", "ö", "ø", "ù", "ú", "û", "ü", "ý", "а", "б", "в", "г", "д", "е", "ё", "ж", 
				"з", "и", "й", "к", "л", "м", "н", "о", "п", "р", "с", "т", "у", "ф", "х", "ц", "ч", "ш", "щ", "ъ", "ы", 
				"ь", "э", "ю", "я" 
				); 
				$convert_from = array( 
				"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", 
				"V", "W", "X", "Y", "Z", "À", "Á", "Â", "Ã", "Ä", "Å", "Æ", "Ç", "È", "É", "Ê", "Ë", "Ì", "Í", "Î", "Ï", 
				"Ð", "Ñ", "Ò", "Ó", "Ô", "Õ", "Ö", "Ø", "Ù", "Ú", "Û", "Ü", "Ý", "А", "Б", "В", "Г", "Д", "Е", "Ё", "Ж", 
				"З", "И", "Й", "К", "Л", "М", "Н", "О", "П", "Р", "С", "Т", "У", "Ф", "Х", "Ц", "Ч", "Ш", "Щ", "Ъ", "Ъ", 
				"Ь", "Э", "Ю", "Я" 
				); 
			
				$str = str_replace($convert_from, $convert_to, $str);
			//FIN: A minusculas todos

			//INI: A mayuscula la letra que siga de punto(.)	
				$convert_to = array( 
				". A", ". B", ". C", ". D", ". E", ". F", ". G", ". H", ". I", ". J", ". K", ". L", ". M", ". N", ". O", ". P", ". Q", ". R", ". S", ". T", ". U", 
				". V", ". W", ". X", ". Y", ". Z", ". À", ". Á", ". Â", ". Ã", ". Ä", ". Å", ". Æ", ". Ç", ". È", ". É", ". Ê", ". Ë", ". Ì", ". Í", ". Î", ". Ï", 
				". Ð", ". Ñ", ". Ò", ". Ó", ". Ô", ". Õ", ". Ö", ". Ø", ". Ù", ". Ú", ". Û", ". Ü", ". Ý", ". А", ". Б", ". В", ". Г", ". Д", ". Е", ". Ё", ". Ж", 
				". З", ". И", ". Й", ". К", ". Л", ". М", ". Н", ". О", ". П", ". Р", ". С", ". Т", ". У", ". Ф", ". Х", ". Ц", ". Ч", ". Ш", ". Щ", ". Ъ", ". Ъ", 
				". Ь", ". Э", ". Ю", ". Я" 
				); 
				$convert_from = array( 
				". a", ". b", ". c", ". d", ". e", ". f", ". g", ". h", ". i", ". j", ". k", ". l", ". m", ". n", ". o", ". p", ". q", ". r", ". s", ". t", ". u", 
				". v", ". w", ". x", ". y", ". z", ". à", ". á", ". â", ". ã", ". ä", ". å", ". æ", ". ç", ". è", ". é", ". ê", ". ë", ". ì", ". í", ". î", ". ï", 
				". ð", ". ñ", ". ò", ". ó", ". ô", ". õ", ". ö", ". ø", ". ù", ". ú", ". û", ". ü", ". ý", ". а", ". б", ". в", ". г", ". д", ". е", ". ё", ". ж", 
				". з", ". и", ". й", ". к", ". л", ". м", ". н", ". о", ". п", ". р", ". с", ". т", ". у", ". ф", ". х", ". ц", ". ч", ". ш", ". щ", ". ъ", ". ы", 
				". ь", ". э", ". ю", ". я" 
				); 
				$str = str_replace($convert_from, $convert_to, $str);
			//FIN: A mayuscula la letra que siga de punto(.)	
		
			return $str;
	 }

	 public function fullUpper($str)
	 {
		 $convert_to = array( 
			"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", 
			"V", "W", "X", "Y", "Z", "À", "Á", "Â", "Ã", "Ä", "Å", "Æ", "Ç", "È", "É", "Ê", "Ë", "Ì", "Í", "Î", "Ï", 
			"Ð", "Ñ", "Ò", "Ó", "Ô", "Õ", "Ö", "Ø", "Ù", "Ú", "Û", "Ü", "Ý", "А", "Б", "В", "Г", "Д", "Е", "Ё", "Ж", 
			"З", "И", "Й", "К", "Л", "М", "Н", "О", "П", "Р", "С", "Т", "У", "Ф", "Х", "Ц", "Ч", "Ш", "Щ", "Ъ", "Ъ", 
			"Ь", "Э", "Ю", "Я" 
		   ); 
		   $convert_from = array( 
			"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", 
			 "v", "w", "x", "y", "z", "à", "á", "â", "ã", "ä", "å", "æ", "ç", "è", "é", "ê", "ë", "ì", "í", "î", "ï", 
			 "ð", "ñ", "ò", "ó", "ô", "õ", "ö", "ø", "ù", "ú", "û", "ü", "ý", "а", "б", "в", "г", "д", "е", "ё", "ж", 
			 "з", "и", "й", "к", "л", "м", "н", "о", "п", "р", "с", "т", "у", "ф", "х", "ц", "ч", "ш", "щ", "ъ", "ы", 
			 "ь", "э", "ю", "я" 
		   ); 
		 
		   return str_replace($convert_from, $convert_to, $str);
	  }




	  public function ControlarSiContinuaPorNumeroSolicitudes($IdProSer)
	  {
		$QueRetornarPorPuedeSeguirPorControlSolicitudes = 'SI';
		$Productos = $this->nodeApi->privateApi("/ProdServ/ParametrosProductosServicios",array(),'GET');
		$Productos = $Productos[0];
		$tam       = count($Productos);
		$data      = array();
		
		for($i=0; $i<$tam; $i++)
		{
			if($Productos[$i]["idtipo"]==$IdProSer)
			{
				$data[]=$Productos[$i];
			}
		}
		
		$Solicitudes = $this->nodeApi->privateApi("/ProdServ/ConsultarSolicitudes",array("idProductoServicio"=>$IdProSer,"cedula"=>$this->objAsociado->__get('cedulasociado')),'GET');
		$Solicitudes = $Solicitudes[0];
		$tamSol      = count($Solicitudes);
		$SolProd     = array();
		$ContSolicitudes = 0;
		
		for($a=0; $a<$tamSol; $a++)
		{
			
			//validamos que si la solicitud fue anulada es porque se libero y no debe ser contemplada en el control de cantidad de solicitudes.
			if ($Solicitudes[$a]["EstadoActual"]=='X')
			{
				continue;
			}	

			$ControlPor = $this->ControlSolicitudes($data[0]["controlpor"]);
			
			if($data[0]["controlpor"]=='S'){
				$msj='semestrales';
				$ValidarMes = in_array($Solicitudes[$a]["mesSolicitud"],$ControlPor);
				if($ValidarMes){
					$SolProd[]=$Solicitudes[$a];
					$ContSolicitudes = count($SolProd);
				}
			}
			else if($data[0]["controlpor"]=='T'){
				$msj='trimestrales';
				$ValidarMes = in_array($Solicitudes[$a]["mesSolicitud"],$ControlPor);
				if($ValidarMes){
					$SolProd[]=$Solicitudes[$a];
					$ContSolicitudes = count($SolProd);
				}
			}
			else if($data[0]["controlpor"]=='B'){
				$msj='bimestrales';
				$ValidarMes = in_array($Solicitudes[$a]["mesSolicitud"],$ControlPor);
				if($ValidarMes){
					$SolProd[]=$Solicitudes[$a];
					$ContSolicitudes = count($SolProd);
				}
			}
			else if($data[0]["controlpor"]=='M'){
				$msj='mensuales';
				if((int)$ControlPor==$Solicitudes[$a]["mesSolicitud"]){
					$SolProd[]=$Solicitudes[$a];
					$ContSolicitudes = count($SolProd);
				}
			}
			else if($data[0]["controlpor"]=='A'){
				$msj='anuales';
				if((int)$ControlPor==$Solicitudes[$a]["anioSolicitud"]){
					$SolProd[]=$Solicitudes[$a];
					$ContSolicitudes = count($SolProd);
				}
			}
		}
		
		if( $ContSolicitudes >= $data[0]["solicitudes"] ) 
		{
			$QueRetornarPorPuedeSeguirPorControlSolicitudes = "Excedes el número total de solicitudes que puedes realizar para este servicio que son: ".$data[0]["solicitudes"]." solicitudes ".$msj . ". Si quieres más información colócate en contacto con nosotros.";
		}


	$this->response=array("estado"=>true,"msj"=>$QueRetornarPorPuedeSeguirPorControlSolicitudes);
			
	return $QueRetornarPorPuedeSeguirPorControlSolicitudes;


	}

	public function ControlSolicitudes($PeriodoAnio)
	{
		if($PeriodoAnio=='M'){
			$periodo = date("m");
		}
		else if($PeriodoAnio=='B'){
			if(in_array(date("m"),array('01','02'))){
				$periodo = array('01','02');
			}
			else if(in_array(date("m"),array('03','04'))){
				$periodo = array('03','04');
			}
			else if(in_array(date("m"),array('05','06'))){
				$periodo = array('05','06');
			}
			else if(in_array(date("m"),array('07','08'))){
				$periodo = array('07','08');
			}
			else if(in_array(date("m"),array('09','10'))){
				$periodo = array('09','10');
			}
			else if(in_array(date("m"),array('11','12'))){
				$periodo = array('11','12');
			}
		}
		else if($PeriodoAnio=='T'){
			if(in_array(date("m"),array('01','02','03'))){
				$periodo = array('01','02','03');
			}
			else if(in_array(date("m"),array('04','05','06'))){
				$periodo = array('04','05','06');
			}
			else if(in_array(date("m"),array('07','08','09'))){
				$periodo = array('07','08','09');
			}
			else if(in_array(date("m"),array('10','11','12'))){
				$periodo = array('10','11','12');
			}
		}
		else if($PeriodoAnio=='S'){
			if(in_array(date("m"),array('01','02','03','04','05','06'))){
				$periodo = array('01','02','03','04','05','06');
			}
			else if(in_array(date("m"),array('07','08','09','10','11','12'))){
				$periodo = array('07','08','09','10','11','12');
			}
		}
		else if($PeriodoAnio=='A'){
			$periodo = date("Y");
		}
		return $periodo;
	}



}	
?>