<?php
date_default_timezone_set('America/Bogota');
setlocale(LC_TIME,"");
class NodeApi {

   // ip
   private $server;
   private $useCertificate;
   private $estado;

   //Segundos a esperar si el servicio no responde
   CONST TIEMPOMAXIMOESPERA=30;

   function NodeApi($useCertificate=true)
   {
	   	$useCertificate=false;
   		$this->useCertificate = $useCertificate;
        //$server="138.121.15.30:16171";        //OPA
        //$server="181.129.53.36:16171";          //COOEBAN
        //$server="181.129.53.34:16171";          //COOEBAN
        $server="181.129.53.37:14444";          //COOEBAN
      
    	$this->server = $useCertificate ? "https://".$server : "http://".$server ;
        
		//INI:Validar conexion con el servicio
        $cu=curl_init();
        $this->curlConfig($cu,$this->server);
        $this->estado=curl_exec($cu)?true:false;
        curl_close($cu);        
		//FIN:Validar conexion con el servicio
   }

   //Configuraciones de la conexion al servicio mendiante curl
   private function curlConfig($cu,$url){
        curl_setopt($cu, CURLOPT_URL, $url);
		curl_setopt($cu, CURLOPT_CONNECTTIMEOUT,self::TIEMPOMAXIMOESPERA);
        curl_setopt($cu, CURLOPT_RETURNTRANSFER, true);
        if($this->useCertificate){
            curl_setopt($cu, CURLOPT_SSL_VERIFYPEER, false); 
        }
        /*
        curl_setopt($cu, CURLOPT_SSL_VERIFYPEER, true );
		curl_setopt($cu, CURLOPT_SSL_VERIFYHOST, 2 );
		curl_setopt($cu, CURLOPT_CAINFO,dirname(dirname(__FILE__)).'/ssl/ssl.crt' );
		curl_setopt($cu, CURLOPT_SSH_PRIVATE_KEYFILE,dirname(dirname(__FILE__)).'/ssl/ssl.key' );
		*/
   }

    private function execute ($url,$params,$type,$dataType){
        try{
            //Se valida conexion con el servidor
            if(!$this->estado)throw new Exception("No fue posible establecer conexión con el servidor, ofrecemos disculpas por las molestias ocasionadas.");

            $cu  = curl_init();
            $this->setHeaders($cu,$dataType);
            $queryString = $this->setParams($cu,$params,$type);
            $this->curlConfig($cu,$url.$queryString);
            
            curl_setopt($cu, CURLOPT_HEADER, true);
            $response = curl_exec($cu);

            //Se discrimina los resultados devueltos por el servicio web, ya que retorna los resultados mas las cabeceras
            $resArray=explode("\r\n",$response);

            //total resultados devueltos por el servicio
            $sizeHeader=count($resArray);

            //El primer resultado se obtiene el estado en string del servicio
            $estado=$resArray[0];

            //Se obtiene el ultimo dato, aqui estan los datos correspondientes a las solicitud realizada
            $data=$resArray[$sizeHeader-1];

            curl_close($cu);
            $datos =json_decode($data, true);

            //Si el error de la peticion es 4xx
            if(strrpos($estado,"HTTP/1.1 4")!==false){
                if(strrpos($estado,"HTTP/1.1 498")!==false){
                    if(strcmp($datos["message"],"El token ha expirado")===0){
                        $_SESSION=array();    
                    }
                    throw new Exception($datos["message"]);    
                }//Mensaje que devuelve el procedimiento almacenado de autenticacion.
                if(strrpos($estado,"HTTP/1.1 401")!==false){
                    throw new Exception($datos["mensaje"]);
                }
                throw new Exception("La solicitud contiene sintaxis incorrecta o no puede procesarse.");
            }
            //Si el error de la peticion es 5xx
            if(strrpos($estado,"HTTP/1.1 5")!==false){
                throw new Exception("El servidor falló al completar una solicitud aparentemente válida.");
            }

            //Si es null asigno el token devuelto a $datos en caso contrario $datos=$datos;
            $datos =is_null($datos)?$data:$datos;
            
            if(is_array($datos)){
                if (isset($datos[0]["token"]) && isset($_SESSION["token"]) ){
                    //Se actualiza el token
                    $_SESSION["token"] = $datos[0]["token"];
                    unset($datos[0]);
                    $array=array();
                    $datos=array_merge($array,$datos);
                }
                if (isset($datos["message"])) {
                  if(strcmp($datos["message"],"El token ha expirado")==0){
                    $_SESSION=array();
                    $datos=array("estado"=>false,"msj"=>"El token ha expirado");
                    header("location:../includes_generales/salida_segura.php");
                    exit;
                  }
                }

            }//Valido que el token si sea de tipo string
            else if(!is_string($datos)){
                throw new Exception('No tiene permitido realizar esta accion');
            }
        }
        catch(Exception $e){
            $datos=array("message"=>$e->getMessage());
        }

        return $datos;
   }

   private function setHeaders ($ch,$dataType)
   {
      $dataType = $dataType === "json" ? "Accept : application/json" : "Accept: application/xml";
      if(isset($_SESSION['token'])){
          $token = is_array($_SESSION['token']) ? "" : "authorization: ".$_SESSION['token'];
      }
      else{
          $token = "";
      }
      $headers =  array($dataType,$token);
      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
   }

   private function setParams ($ch,$params,$type)
   {
      $url="";
      $aux="";
	  foreach($params as $clave=>$value){
          if(strtoupper($type)=="GET"){
            $aux.=$clave."=".urlencode($value)."&";
          }
          else{
	  	    $aux.=$clave."=".$value."&";
          }
      }
	  $aux=substr($aux,0,strlen($aux)-1);

      switch (strtoupper($type)) {
         case 'GET':
            //$url = '?' . http_build_query($params);            
			$url = '?' . $aux;
            break;

         case 'POST':
            //curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
			curl_setopt($ch, CURLOPT_POSTFIELDS, $aux);
            break;

         case 'PUT':
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
            //curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
			curl_setopt($ch, CURLOPT_POSTFIELDS, $aux);
            break;

         case 'DELETE':
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
            //curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
			curl_setopt($ch, CURLOPT_POSTFIELDS, $aux);
            break;
         default:
            throw new Exception("Metodo desconocido utilice por favor POST PUT GET O DELETE");
            break;
      }

      return $url;
   }

   // public methods
   public function publicApi($resource,$params,$type,$dataType="json")
   {
      $url = $this->server."/public/api".$resource;
      return $this->execute($url,$params,$type,$dataType);
   }

   public function privateApi($resource,$params,$type,$dataType="json")
   {
      $url = $this->server."/private/api".$resource;
      return $this->execute($url,$params,$type,$dataType);
   }

   public function auth($resource,$params,$type,$dataType="json")
   {
      if (session_id() === ''){
         throw new Exception ("No hay una session establecida");
      }

      $url   = $this->server.$resource;
      $token = $token = $this->execute($url,$params,$type,$dataType);
      $_SESSION["token"] = $token;
      return $token;
   }

   public function __getEstado(){
		return $this->estado;
   }

}
