<?php
class Asociado extends Nit{
	protected 
		$cedulasociado,
		$codnit,
		$codempresa,
		$coddependencia,
		$periododeduce,
		$fechanacimiento,
		$deduceocacional,
		$sexo,
		$estudios,
		$codprofesion,
		$estadocivil,
		$nroacta,
		$fechaacta,
		$salario,
		$codempresalabora,
		$fechaingresoLabora,
		$tipocontrato,
		$fechaterminacontrato,
		$cargo,
		$codbanco,
		$numerocuenta,
		$agencia,
		$codanalista,
		$rutaanalista,
		$tipocuenta,
		$estado,
		$ultimaactualizacion,
		$operadoractualizo,
		$paisnace,
		$dptonace,
		$ciudadnace,
		$idnits,
		$idtipovivienda,
		$szin,
		$idtiposalario,
		$tipopacto,
		$web,
		$idasociados,
		$codigotipo;
		
	public function Asociado($cedula=""){
		parent::__construct($cedula);
		$this->cedulasociado=$cedula;		
		if($cedula!=""){
			$this->ConsultarInformacion();
		}
	}
	
	public function ConsultarInformacion(){
		try{
			$result 	=	$this->nodeApi->privateApi("/Modelo/Asociado",array("cedula"=>$this->cedulasociado),'GET');			
			if(isset($result["name"])){
				throw new Exception("Error consultando informacion del asociado");
			}			
			else if(count($result[0])<=0){
				throw new Exception("Asociado no existe");	
			}
			$datos					=	$result[0][0];
			
			$this->cedulasociado	=$datos["cedulasociado"];
			$this->codnit			=$datos["codnit"];
			$this->codempresa		=$datos["codempresa"];
			$this->coddependencia	=$datos["coddependencia"];
			$this->periododeduce	=$datos["periododeduce"];
			$this->fechanacimiento	=$datos["fechanacimiento"];
			$this->deduceocacional	=$datos["deduceocacional"];
			$this->sexo				=$datos["sexo"];
			$this->estudios			=$datos["estudios"];
			$this->codprofesion		=$datos["codprofesion"];
			$this->estadocivil		=$datos["estadocivil"];
			$this->nroacta			=$datos["nroacta"];
			$this->fechaacta		=$datos["fechaacta"];
			$this->salario			=$datos["salario"];
			$this->codempresalabora	=$datos["codempresalabora"];
			$this->fechaingresoLabora=$datos["fechaingresoLabora"];
			$this->tipocontrato		=$datos["tipocontrato"];
			$this->fechaterminacontrato=$datos["fechaterminacontrato"];
			$this->cargo			=$datos["cargo"];
			$this->codbanco			=$datos["codbanco"];
			$this->numerocuenta		=$datos["numerocuenta"];
			$this->agencia			=$datos["agencia"];
			$this->codanalista		=$datos["codanalista"];
			$this->rutaanalista		=$datos["rutaanalista"];
			$this->tipocuenta		=$datos["tipocuenta"];
			$this->estado			=$datos["estado"];
			$this->ultimaactualizacion=$datos["ultimaactualizacion"];
			$this->operadoractualizo=$datos["operadoractualizo"];
			$this->paisnace			=$datos["paisnace"];
			$this->dptonace			=$datos["dptonace"];
			$this->ciudadnace		=$datos["ciudadnace"];
			$this->idnits			=$datos["idnits"];
			$this->idtipovivienda	=$datos["idtipovivienda"];
			$this->szin				=$datos["szin"];
			$this->idtiposalario	=$datos["idtiposalario"];
			$this->tipopacto		=$datos["tipopacto"];
			$this->web				=$datos["web"];
			$this->idasociados		=$datos["idasociados"];
			$this->codigotipo		=$datos["codigotipo"];			
			$this->error			=false;
		}
		catch(Exception $a){
			$this->error=$a->getMessage();
			return NULL;
		}
	}
	public function ultimoIngreso(){
		$resultado=$this->nodeApi->privateApi("/General/UltimoIngreso",array("cedula"=>$this->cedulasociado),"GET");
		return $resultado[0]["fechaultimoingreso"];
		
	}
	public function getError(){
		return $this->error;
	}
	
	public function __set($variable,$valor){
		if(property_exists($this,$variable)){
			$this->$variable=strtoupper($valor);
		}
	}
	
	public function __get($variable){
		if(property_exists($this,$variable)){
			return $this->$variable;
		}
		return NULL;
	}	
}
?>