angular.module("EleccionDelegados",[])
.factory("$validar",function(){
	var obj={
		checkData:function(data){
				try{
					//Comprueba que la data sea valida
					if(data==undefined || data==false )throw 'Error en la data';
					//Comprueba el codigo de estado del servidor
					if(data.status!=200)throw 'Error en la solicitud';
					//Comprueba si el servicio retornó algun mensaje de error
					if(data.data.message!=null)throw data.data.message;

					return true;
				}
				catch(err){
					salidaSegura();
					return false;
				}	
		}
	}
	return obj;
})
.controller("ctrDelegados",["$scope","$http","$interval","$validar",function($scope,$http,$interval,$validar){
	
	//Plachas a mostrar
	$scope.planchas=[];

	//Datos del producto a modificar
	$scope.placha={};

	//Respuestas 
	$scope.response=[];	
	
	//Integrantes
	$scope.delegados=[];
	
	//Consultar productos disponibles para devolucion de ahorros
	$scope.getDelegados=function(){
		CargandoMostrar();
		$http({
			method:'POST',
			url:'ctr/ctr_delegados.php',
			data:{'caso':1}
		}).then(
			function success(res){
				try{
					$validar.checkData(res);
					
					if(res.data.estado==true){
						$scope.planchas=res.data.planchas;
						if($scope.planchas.length==0){
							$scope.response={
								estado:false,
								msj:"En el momento no hay planchas disponibles."
							}
						}
						$("#divbutton").css("display","block");
					}
					else{
						$scope.response={
								estado:res.data.estado,
								msj:res.data.msj
							}
						$scope.planchas=res.data.VotoRealizado;
					}
				}
				catch(err){
					$scope.response=res.data;
				}
				finally{
					cerrarCargando();
				}								
			},
			function error(err){
				$validar.checkData(err);
				$scope.response={
						estado:false,
						msj:"No fue posible realizar la petición solicitada"
					}
				cerrarCargando();
			}
		)
	}

	$scope.getDelegados();

	$scope.integrantes=function(codigos){		
		var datos=$scope.placha;
	
		datos["caso"]=2;
		datos["numplancha"]=codigos.numplancha;
		datos["codvotacion"]=codigos.codvotacion;
		
		CargandoMostrar();
		$http({
			method:'POST',
			url:'ctr/ctr_delegados.php',
			data:datos
		}).then(
			function success(res){
				try{
					$validar.checkData(res);
					$scope.delegados=res.data.integrantes;
				}
				catch(err){
					$scope.response={
						estado:false,
						msj:"Error ejecutando procedimiento por favor comuniquese con la entidad"
					}
				}
				finally{
					cerrarCargando();
				}
			},
			function error(err){
				$validar.checkData(err);
				$('#myModal').modal('hide')
				$scope.response={
					estado:false,
					msj:"Error ejecutando procedimiento por favor comuniquese con la entidad"
				}
				cerrarCargando();
			}
		)
	}
	
	$scope.votar=function(){		
		var datos=$scope.votos;
		
		var check = document.getElementsByName('check');
	
		var resultado;
		var valida= -1;
		for(var i=0;i<check.length;i++)
        {
            if(check[i].checked){
				resultado=check[i].value;
				var valida=i;
			}
        }
		
		if(valida<0){
			$scope.response={
				estado:false,
				msj:"Para realizar el voto debe escoger una de las planchas."
			}
			return false;
		}
		resultado=resultado.split("|");
		$("#btnVotar").attr('disabled',true);
		CargandoMostrar();
		$http({
			method:'POST',
			url:'ctr/ctr_delegados.php',
			data:{'caso':3,'numplancha':resultado[0],'codvotacion':resultado[1]}
		}).then(
			function success(res){
				try{
					$validar.checkData(res);
					//console.log(res.data.msj);
					alert(res.data.msj);
					window.location='../saldos';
				}
				catch(err){
					$scope.response={
						estado:false,
						msj:"Error ejecutando procedimiento por favor comuniquese con la entidad"
					}
					$("#btnVotar").attr('disabled',false);
				}
				finally{
					cerrarCargando();
				}
			},
			function error(err){
				$validar.checkData(err);
				$('#myModal').modal('hide')
				$scope.response={
					estado:false,
					msj:"Error ejecutando procedimiento por favor comuniquese con la entidad"
				}
				$("#btnVotar").attr('disabled',false);
				cerrarCargando();
			}
		)
	}

}])