<?php
require_once dirname(dirname(dirname(__FILE__)))."/vendor/autoload.php";

class Delegados{

	protected 	$asociado,
				$response;
				

	protected $nodeApi;
	
	public function Delegados($cedula){		
		$this->nodeApi		=new NodeApi(false);
		$this->asociado 	=$cedula;

		if(!$this->nodeApi->__getEstado()){
			$this->response=array("estado"=>false,"msj"=>"No fue posible establecer conexion con el servicio web");
		}
		else{
			$this->response=array("estado"=>true,"msj"=>"Conexión realizada con exito");
		}
	}
	
	//Retorna los productos disponibles para el cambio de cuota de ahorros
	public function votacionesDisponibles(){
		try{
			$result=$this->nodeApi->privateApi("/Delegados/Votaciones",array(),"GET");
			if(is_null($result))throw new Exception("No fue posible consultar las votaciones");			
		
			if(count($result)<=0)throw new Exception("No hay votaciones abiertas en este momento");
			
			$registros=array();

			for($i=0;$i<count($result);$i++){
				$dateinicio 	= new DateTime($result[$i]['fechainicio']);
				$datefin 		= new DateTime($result[$i]['fechafin']);
				
				$fechainicio 	= $dateinicio->format('Y-m-d H:i:s');
				$fechafin 		= $datefin->format('Y-m-d H:i:s');
				$fechaactual 	= date('Y-m-d H:i:s');
				
				if($fechainicio<$fechaactual and $fechafin>$fechaactual){
					$registros[]=$result[$i]['codigo'];
				}
			}
			
			if(count($registros)<=0)throw new Exception("En el momento no hay elecciones vigentes.");
			//$this->response=array("estado"=>true,"msj"=>"votaciones consultadas correctamente");
			return $registros;
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}
	
	public function validaSiPuedeVotar($codvotacion){
		try{
			$result=$this->nodeApi->privateApi("/Delegados/ValidaSiPuedeVotar",array("cedula"=>$this->asociado,"codvotacion"=>$codvotacion),"GET");		
			
			if(count($result)>0){
				$votoRealizado=$this->planchas($result[0]['numeroplancha'],$result[0]['codigovotacion'],3);
				//$this->response=array("estado"=>false,"msj"=>"");
				return $votoRealizado;
			}
			//var_dump($votoRealizado);
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}
	
	public function planchas($numplancha="",$codigoVotacion,$caso){
		try{
			$result=$this->nodeApi->privateApi("/Delegados/Planchas",array("numplancha"=>$numplancha,"codvotacion"=>$codigoVotacion,"caso"=>$caso),"GET");
			
			if(is_null($result))throw new Exception("No fue posible consultar las planchas");			
		
			if(count($result)<=0)throw new Exception("No hay planchas disponibles en el momento");
			
			$registros=array();
			if($caso=='1'){
				$numeroplancha=0;
				for($i=0;$i<count($result[0]);$i++){
					if($numeroplancha!=$result[0][$i]["numeroplancha"]){
						
						$numeroplancha = $result[0][$i]["numeroplancha"];
						if($result[0][$i]["cedula"]==0){
							$planchas = "Voto en Blanco";
						}
						else{
							$planchas = "Plancha # ".$result[0][$i]["numeroplancha"];
						}
						
						$registros[]=array("nombre"=>$planchas,"cedula"=>$result[0][$i]["cedula"],"codvotacion"=>trim($result[0][$i]["codigovotacion"]),"numplancha"=>$result[0][$i]["numeroplancha"]);
					}
				}
				
				//$this->response=array("estado"=>true,"msj"=>"planchas consultadas correctamente");
				return $registros;
			}
			else if($caso=='2'){
				for($i=0;$i<count($result[0]);$i++){
					$registros[]=$result[0][$i];
				}
				//$this->response=array("estado"=>true,"msj"=>"integrantes consultados correctamente");
				return $registros;
			}
			else if($caso=='3'){
				$Votos=array();				
				$numvotos=0;
				for($i=0;$i<count($result[0]);$i++){
					if($numvotos!=$result[0][$i]["numeroplancha"]){
						
						$numvotos = $result[0][$i]["numeroplancha"];
							
						if($result[0][$i]["cedula"]==0){
							$planchas = "Voto en Blanco";
						}
						else{
							$planchas = "Plancha # ".$result[0][$i]["numeroplancha"];
						}
						
						$Votos[]=array("nombre"=>$planchas,"cedula"=>$result[0][$i]["cedula"],"codvotacion"=>trim($result[0][$i]["codigovotacion"]),"numplancha"=>$result[0][$i]["numeroplancha"]);
					}
					
				}
				$this->response=array("estado"=>false,"msj"=>"Señor asociado usted ya realizó su voto en las elecciones vigentes. Su voto es el siguiente:");
				return $Votos;
			}
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}
	
	public function RegistrosVotos(){
		try{
			$result=$this->nodeApi->privateApi("/Delegados/GuardarVoto",array("numplancha"=>$numplancha,"codvotacion"=>$codvotacion,"cedula"=>$this->asociado,
												"ip"=>ObtenerIp(),"fechavoto"=>date('Y-m-d H:i:s')),"POST");
			if(!is_array($result))throw new Exception("Ha ocurrido un error interno, por favor intente más tarde");			
		
			$this->response=array("estado"=>true,"msj"=>"Voto realizado con éxito.");
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}
	
	public function GuardarVoto($numplancha,$codvotacion){
		try{
			$result=$this->nodeApi->privateApi("/Delegados/GuardarVoto",array("numplancha"=>$numplancha,"codvotacion"=>$codvotacion,"cedula"=>$this->asociado,
												"ip"=>ObtenerIp(),"fechavoto"=>date('Y-m-d H:i:s')),"POST");
			if(!is_array($result))throw new Exception("Ha ocurrido un error interno, por favor intente más tarde");			
		
			$this->response=array("estado"=>true,"msj"=>"Voto realizado con éxito.");
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}

	public function getResponse(){
		return $this->response;
	}
	
}
?>