<?php
require_once dirname(dirname(dirname(__FILE__)))."/vendor/autoload.php";

class CostoAdicional{
    private $nodeApi,
            $response;

    public function CostoAdicional(){
        $this->nodeApi=new NodeApi();
        $this->response=array("estado"=>false,"msj"=>"Error consultando costos");
    }

    public function costosAdicionales(){
        try{
            $res=$this->nodeApi->privateApi("/Costos",array(),'GET');
            
            $res=$res[0];
            
            if(is_null($res))throw new Exception("No fue posible consultar los costos");

            $this->response=array("estado"=>true,"msj"=>"Costos consultados correctamente","datos"=>$res);
        }
        catch(Exception $e){
            $this->response=array("estado"=>false,"msj"=>$e->getMessage());
        }
    }

    //Guarda los costos que se van a simular en la web
    public function guardarConfiguracion($idCostos){
        try{
            $idCostos=$this->convertirJsonAXml($idCostos);

            $res=$this->nodeApi->privateApi("/Costos",array("costos"=>$idCostos),'POST');
            
            if(is_null($res))throw new Exception("No fue posible actualizar los costos");
            
            $this->response=array("estado"=>true,"msj"=>"Costos actualizados correctamente");
           
        }
        catch(Exception $e){
            $this->response=array("estado"=>false,"msj"=>$e->getMessage());
        }
    }

    private function convertirJsonAXml($json){
        $xml="<root>";
        foreach($json as $clave=>$valor){
            $xml.=" <costo>
                        <idcostoadicional>$valor->idcostoadicional</idcostoadicional>
                        <web>$valor->web</web>
                    </costo>";
        }
        $xml.="</root>";
        return $xml;
    }

    public function getResponse(){
        return  $this->response;
    }

}
?>