(function(window,angular){

angular.module("modCostos",['ngRoute'])
.config(function($routeProvider){
    $routeProvider
    .when('/costos',{
        templateUrl:"../costos_adicionales/index.php",
        controller:"ctrCostos",
        controllerAs:"ctrCostos"
    })
})
.controller("ctrCostos",["$scope","srvCostos",function($scope,srvCostos){    
    $scope.costos=[]; 
    
    $scope.response={estado:true,msj:""}

    srvCostos.costos().then(
        function success(res){
            var data=res.data.datos;           
            var codLinea,codDestino,index=-1;
            
            try{
                for(var i in data){
                    if(codLinea!=data[i].codlinea || codDestino!=data[i].coddestino){
                        index++;
                        $scope.costos.push(
                            {   id:data[i].idcostoadicional,
                                "nombreDestino":data[i].nombredestino,
                                codLinea:data[i].codlinea,
                                codDestino:data[i].coddestino,
                                costos:[]
                            });
                    }
                    codLinea=data[i].codlinea;
                    codDestino=data[i].coddestino;
                    
                    $scope.costos[index]["costos"].push({
                        idcostoadicional:data[i].idcostoadicional,
                        tipocosto:data[i].tipocosto,
                        nombrecosto:data[i].nombrecosto,
                        valor:data[i].valor,
                        web:data[i].web,
                        modify:false,                   
                    });
                    
                }      
            }
            catch(err) {
                console.log("Error mostrando costos: "+err.message)
            }
            
        },
        function error(err){
            $scope.response={estado:false,msj:"Error consultando los costos"};
        }
    );  

    $scope.costosModificados=function(id){
        id.modify=true;
    }

    $scope.guardar=function(){
        $scope.response={estado:false,msj:""};
        try{
            var idCostos=[];            
            for(var i in $scope.costos){
                for(var k in $scope.costos[i].costos){
                    if($scope.costos[i].costos[k].modify)
                        idCostos.push($scope.costos[i].costos[k]);
                }
            }

            srvCostos.guardarConfig(idCostos).then(
                function success(res){
                    $scope.response=res.data;            
                }
            );            
        }
        catch(err){
            $scope.response={estado:false,msj:"Error guardando los cambios realizados"};
        }

    }


}])
.service("srvCostos",["$http",function($http){

    this.costos=function(){
        CargandoMostrar();
        return $http({
            method:"POST",
            url:"../costos_adicionales/ctr/ctrCostos.php",
            data:{caso:1}
        }).then(
            function success(res){
                cerrarCargando();
                return res;
            },
            function error(err){
                cerrarCargando();
                return err;                   
            });          
    }

    this.guardarConfig=function(costos){
        CargandoMostrar();
        return $http({
            method:"POST",
            url:"../costos_adicionales/ctr/ctrCostos.php",
            data:{caso:2,idCostos:costos}
        }).then(
            function success(res){
                cerrarCargando();
                return res;
            },
            function error(err){
                cerrarCargando();
                return err;
            });        
    }
}])

})(window,window.angular);
