(function(window, angular){
	var app=angular.module('modCorpClasificados',['ngRoute']);
	app.config(function($routeProvider){
		$routeProvider
		.when("/",{
			templateUrl:"../clasificados/vista/view_corporativo.php",
			controller:"ctrCorpClasificados"
		})
	})

	app.factory('$factory',function(){
		var obj={
			clasificado:undefined,
			valResponse:function(res){
				try{
			        if(res.status==404)throw {'message':'Servicio no encontrado'}
			        if(res.data.message!=undefined)throw res.data;
			        if(res.data.estado!=undefined && !res.data.estado)throw {'message':res.data.msj};
			        cerrarCargando();
			        return {'estado':true};
		      	}
		      	catch(err){
			        cerrarCargando();
			        return {'estado':false,'msj':err.message}
			    }
			},
			focus:function(id){
				var id=document.querySelector("#"+id);
				if (id!=undefined) {
					id.focus();
				}
			}
		}
		return obj;
	})

	app.service('$serv',['$http',function($http){

		this.listarClasificadosCorporativo = () => {
			CargandoMostrar()
			return $http({
				method:'POST',
				url:'../clasificados/controlador/ctr_Clasificados.php',
				data:{
					'caso': '4'
				},
				header:{
					'Content-Type':'application/json'
				}
			})
		}

		this.aumentarVistas = (data) => {
			CargandoMostrar()
			return $http({
				method:'POST',
				url:'../clasificados/controlador/ctr_Clasificados.php',
				data:{
					'caso' : '12',
					'datos': data
				},
				header:{
					'Content-Type':'application/json'
				}
			})
		}
	}])

	app.controller('ctrCorpClasificados',['$scope','$serv','$factory',
	function($scope,$serv,$factory){
		$scope.listarClasificadosCorporativo = [];
		$scope.infoClasificado = [];
		$scope.infoClasificadoAdjuntos = [];
		$scope.response;
		CargarCombos("24,,tipoClasificado,");
		CargarCombos("25,,categoriaClasificado,");

		$scope.listar = () => {
			$serv.listarClasificadosCorporativo().then(
			function(res){
				//console.log(res)
				var valResponse= $factory.valResponse(res);
				if (!valResponse['estado']) {
					$scope.response=valResponse;
				}
				$scope.listarClasificadosCorporativo=res.data;
			},
			function(err){
		      $scope.response=$factory.valResponse(err);
		    })
		}

		$scope.listar();

		$scope.verInfo = (numero) => {
			for (var i = 0; i < $scope.listarClasificadosCorporativo.length; i++) {
				if (numero.trim() == $scope.listarClasificadosCorporativo[i].numero.trim()) {
					$scope.infoClasificado = $scope.listarClasificadosCorporativo[i];
					$scope.infoClasificadoAdjuntos = $scope.listarClasificadosCorporativo[i].adjuntos.split('|')
					var data = {
						'numero' : $scope.listarClasificadosCorporativo[i].numero.trim(),
						'cedula' : $scope.listarClasificadosCorporativo[i].asociado.trim()
					}
					console.log($scope.infoClasificado)
					$serv.aumentarVistas(data).then(
					function(res){
						if (res.status==200) {
							//console.log("Transacción correcta")
						}
					})
				}
			}
		}

		$("#tipoClasificado").change(function(){
			$(".clasificadosMostrar").hide();
			$(".clasificadosMostrar[tipo="+this.value+"]").show();
		})

		$("#categoriaClasificado").change(function(){
			$(".clasificadosMostrar").hide();
			$(".clasificadosMostrar[category="+this.value+"]").show();
		})
	}])
})(window,window.angular);