(function(window, angular){
	var app=angular.module('modClasificados',['ngRoute']);
	app.config(function($routeProvider){
		$routeProvider
		.when("/",{
			templateUrl:"../clasificados/vista/view_clasificados.php",
			controller:"ctrClasificados"
		})
	})

	app.factory('$factory',function(){
		var obj={
			clasificado:undefined,
			valResponse:function(res){
				try{
			        if(res.status==404)throw {'message':'Servicio no encontrado'}
			        if(res.data.message!=undefined)throw res.data;
			        if(res.data.estado!=undefined && !res.data.estado)throw {'message':res.data.msj};
			        cerrarCargando();
			        return {'estado':true};
		      	}
		      	catch(err){
			        cerrarCargando();
			        return {'estado':false,'msj':err.message}
			    }
			},
			focus:function(id){
				var id=document.querySelector("#"+id);
				if (id!=undefined) {
					id.focus();
				}
			}
		}
		return obj;
	})

	app.service('$serv',['$http',function($http){

		this.listarClasificados = () => {
			CargandoMostrar()
			return $http({
				method:'POST',
				url:'../clasificados/controlador/ctr_Clasificados.php',
				data:{
					'caso': '3'
				},
				header:{
					'Content-Type':'application/json'
				}
			})
		}

		this.crearClasificados = (data) => {
			CargandoMostrar()
			return $http({
				method:'POST',
				url:'../clasificados/controlador/ctr_Clasificados.php',
				data:{
					'caso': '5',
					'datos': data
				},
				header:{
					'Content-Type':'application/json'
				}
			})
		}

		this.editarClasificados = (data) => {
			CargandoMostrar()
			return $http({
				method:'POST',
				url:'../clasificados/controlador/ctr_Clasificados.php',
				data:{
					'caso': '6',
					'datos': data
				},
				header:{
					'Content-Type':'application/json'
				}
			})
		}

		this.borrarClasificados = (data) => {
			CargandoMostrar()
			return $http({
				method:'POST',
				url:'../clasificados/controlador/ctr_Clasificados.php',
				data:{
					'caso': '7',
					'datos': data
				},
				header:{
					'Content-Type':'application/json'
				}
			})
		}
	}])

	app.controller('ctrClasificados',['$scope','$serv','$factory',
	function($scope,$serv,$factory){
		$scope.listClasificados = [];
		$scope.editClasificado = [];
		$scope.editAdjuntos = [];
		$scope.ediNumero = [];
		$scope.clasificadoBorrar = [];
		$scope.response;

		$scope.listar = () => {
			$serv.listarClasificados().then(
			function(res){
				//console.log(res)
				var valResponse= $factory.valResponse(res);
				console.log(valResponse['estado']);
				if (!valResponse['estado']) {
					$scope.response=valResponse;
				}
				$scope.listClasificados=res.data;
				CargarCombos("24,,tipoClasificadoCrear,");
				CargarCombos("25,,categoriaClasificadoCrear,");
				//console.log($scope.listClasificados)
				//console.log($scope.response)
			},
			function(err){
		      $scope.response=$factory.valResponse(err);
		    })
		}

		$scope.listar();

		$scope.editMostrar = (numero) => {
			$serv.listarClasificados().then(
			function(res){
				var valResponse= $factory.valResponse(res);
				if (!valResponse['estado']) {
					$scope.response=valResponse;
				}
				for (var i = 0; i < res.data.length; i++) {
					if (numero.trim() == res.data[i].numero.trim()) {
						//console.log(res.data[i].causaeli.trim());
						$scope.editClasificado = res.data[i];
						$scope.editAdjuntos = res.data[i].adjuntos.split('|')
						$scope.ediNumero = numero.trim();
					}
				}
				console.log($scope.editClasificado)
			},
			function(err){
		      $scope.response=$factory.valResponse(err);
		    })
		}

		$scope.crear = () => {

			if ($('#tipoClasificadoCrear').val()!='' && $('#categoriaClasificadoCrear').val()!='' && $('#mensajeClasificadoCrear').val()!='' && $('#precioClasificadoCrear').val()!='' && $('#nombreClasificadoCrear').val()!='' && $('#telClasificadoCrear').val()!='' && $('#emailClasificadoCrear').val()!='') 
			{
				$("#frmClasificados").submit()
			}
			else
			{
				Swal.fire({
					icon: 'warning',
					title: 'Revise que todos los campos esten llenos'
				});
			}
		}

		$scope.editar = () => {
			$("#frmClasificadosEditar").submit()
		}

		$scope.borrar = (numero) => {

			$scope.clasificadoBorrar = numero;
			CargarCombos("26,,motivoEliminar,");			
		}

		$scope.eliminar = () => {

			data = {
				'numero' : $("#numeroEliminar").val(),
				'motivo' : $("#motivoEliminar").val()
			}

			if (data.motivo.trim() != 0) 
			{
				$serv.borrarClasificados(data).then(
				function(response){
					if (response.status==200) {
						cerrarCargando();
						Swal.fire({
							icon: 'success',
							title: 'Eliminado correctamente',
							confirmButtonText: 'OK',
						}).then((result) => {
							//console.log(result);
							if (result) {
								window.location.href = "index.php";
							}
						})
					}
				})
			}
			else
			{
				Swal.fire('Por favor, elija un motivo')
			}
		}

	}])
})(window,window.angular);

countChars = (obj) => {
    document.getElementById("contDescripcion").innerHTML = obj.value.length+' caracteres';
    document.getElementById("contDescripcionCrear").innerHTML = obj.value.length+' caracteres';
}

sinLetras = (string) => {//Solo numeros
    var out = '';
    var filtro = '1234567890';//Caracteres validos
	
    //Recorrer el texto y verificar si el caracter se encuentra en la lista de validos 
    for (var i=0; i<string.length; i++)
       if (filtro.indexOf(string.charAt(i)) != -1) 
             //Se añaden a la salida los caracteres validos
	     out += string.charAt(i);
	
    //Retornar valor filtrado
    return out;
}