<?php
require_once dirname(__FILE__)."/../../vendor/autoload.php";

class Clasificados{

	private $cedula;
	private $nodeApi;

	public $response;

	function Clasificados(){
		$this->nodeApi 	=new NodeApi(false);
		$this->cedula 	=$_SESSION["CEDULA"];
	}

	public function listaClasificados($caso) {
		try {
			$result=$this->nodeApi->privateApi("/Clasificados/transaccional",array("caso"=>$caso, "cedula"=>$this->cedula),'POST');
			if (!is_null($result)) {
				$this->response=$result[0];
			}else{
				throw new Exception("No fue posible realizar la transaccion solicitada");
			}
		}catch(Exception $e) {
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}

	public function listaClasificadosCorporativo($caso) {
		try {
			$result=$this->nodeApi->publicApi("/Clasificados/corporativo",array("caso"=>$caso),'POST');
			if (!is_null($result)) {
				$this->response=$result[0];
			}else{
				throw new Exception("No fue posible realizar la transaccion solicitada");
			}
		}catch(Exception $e) {
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}

	public function crearClasificados($caso, $datos) {
		try {
			$result=$this->nodeApi->privateApi("/Clasificados/transaccional",array(
				"caso"			=>$caso, 
				"cedula"		=>$this->cedula,
				"numero"		=>$datos["numero"],
				"codoperador"	=>"OPAM",
				"fecha"			=>$datos["fecha"],
				"telefonos"		=>$datos["telefono"],
				"tipo"			=>$datos["tipo"],
				"categoria"		=>$datos["categoria"],
				"mensaje"		=>$datos["mensaje"],
				"nombre"		=>$datos["nombre"],
				"email"			=>$datos["email"],
				"precio" 		=>$datos["precio"],
				"adjuntos"		=>$datos["adjuntos"]
			),'POST');
			if (!is_null($result)) {
				header('location:../index.php#/');
				exit;
			}else{
				throw new Exception("No fue posible realizar la transaccion solicitada");
			}
		}catch(Exception $e) {
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}

	public function editarClasificados($caso, $datos) {
		try {
			$result=$this->nodeApi->privateApi("/Clasificados/transaccional",array(
				"caso"			=>$caso, 
				"cedula"		=>$this->cedula,
				"numero"		=>$datos["numero"],
				"codoperador"	=>"OPAM",
				"fecha"			=>$datos["fecha"],
				"telefonos"		=>$datos["telefono"],
				"tipo"			=>$datos["tipo"],
				"categoria"		=>$datos["categoria"],
				"mensaje"		=>$datos["mensaje"],
				"nombre"		=>$datos["nombre"],
				"email"			=>$datos["email"],
				"precio" 		=>$datos["precio"],
				"adjuntos"		=>$datos["adjuntos"]
			),'POST');
			if (!is_null($result)) {
				header('location:../index.php#/');
				exit;
			}else{
				throw new Exception("No fue posible realizar la transaccion solicitada");
			}
		}catch(Exception $e) {
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}

	public function borrarClasificados($caso, $datos) {
		try {
			$result=$this->nodeApi->privateApi("/Clasificados/transaccional",array("caso"=>$caso, "cedula"=>$this->cedula, "numero"=>$datos["numero"], "causaeliminacion"=>$datos["motivo"]),'POST');
			if (!is_null($result)) {
				$this->response=$result;
			}else{
				throw new Exception("No fue posible realizar la transaccion solicitada");
			}
		}catch(Exception $e) {
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}

	public function aumentarVista($caso, $datos) {
		try {
			$result=$this->nodeApi->publicApi("/Clasificados/corporativo",array("caso"=>$caso, "numero"=>$datos["numero"], "cedula"=>$datos["cedula"]), 'POST');
			if (!is_null($result)) {
				$this->response=$result;
			}else{
				throw new Exception("No fue posible realizar la transaccion solicitada");
				
			}
		}catch(Exception $e) {
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}
}

?>