<?php
require_once "../vendor/autoload.php";
class Cert_Retencion extends Seguridad{
	protected $nodeApi,$error,$cedula,$year,$descripcion;
	
	public function Cert_Retencion($cedula="",$fechadesde="",$fechafin="",$year=""){
		parent::__construct();
		$this->cedula=$cedula;
		$this->year=$year;
		$this->fechadesde=$fechadesde;
		$this->fechafin=$fechafin;		
		$this->error=false;
		$this->nodeApi=new NodeApi(false);
		if($this->cedula!="" && $year!=""){
			$this->Datos();
		}
	}
	  
	public function Datos(){
		try{
			$result=$this->nodeApi->privateApi("/Certificado/Circular",array("cedula"=>$this->cedula,"year"=>$this->year),"GET");
			if(isset($result["name"])){
				throw new Exception("Error consultando informacion");
			}
			else if(count($result[0])<=0){
				throw new Exception("No se ha generado el certificado correspondiente al año seleccionado");	
			}
			$result=$result[0];
			$this->descripcion=$result["descripcion"];
		}
		catch(Exception $e){
			$this->error=$e->getMessage();
		}		
	}
	
	public function Cert_Generados(){
		try{
			$result=$this->nodeApi->privateApi("/Certificado/Retencion004",array("CedulaSociado"=>$this->cedula,"Agencia"=>"1",
												"FechaDesde"=>$this->fechadesde,"FechaFin"=>$this->fechafin),"GET");

			if(isset($result["name"])){
				throw new Exception("Error consultando informacion");
			}
			else if(count($result[0])<=0){
				throw new Exception("No se han generado certificados");	
			}
			return $result;
		}
		catch(Exception $e){
			$this->error=$e->getMessage();
		}	
	}

	/*Consulta el interes causado periodo y el interes pagado periodo*/
	public function intereses(){
		try{
			$result=$this->nodeApi->privateApi("/Certificado/Retencion004/Interes",array("year"=>$this->year,"cedulasociado"=>$this->cedula,),"GET");
			
			if(isset($result["name"])){
				throw new Exception("Error consultando los interes");
			}
			else if(count($result[0])<=0){
				throw new Exception("No se han generado certificados");	
			}
			return $result;
		}
		catch(Exception $e){
			$this->error=$e->getMessage();
		}	
	}
	public function nombreCompania(){		
		try{
			$infor=$this->nodeApi->privateApi("/Informe/Cabezote",array("cedula"=>$this->cedula),'POST');
			
			if(isset($infor["name"])){
				throw new Exception("Error consultando informacion");
			}
			else if(count($infor[0])<=0){
				throw new Exception("No se han generado certificados");	
			}
			return $infor[0][0]["nombrecompania"];
		}
		catch(Exception $e){
			$this->error=$e->getMessage();
		}	
	}
	
	public function CrearLog(){
		try{
			$result=$this->nodeApi->privateApi("/Certificado/CrearLog",array("cedula"=>$this->cedula,"ip"=>ObtenerIp(),"year"=>$this->year,"fecha"=>date('Y/m/d H:i:s')),"PUT");
			if(isset($result["name"])){
				throw new Exception("Error consultando informacion");
			}
			return $result;
		}
		catch(Exception $e){
			$this->error=$e->getMessage();
		}
	}

	//OPCION NUEVA PARA LA CONSULTA DE OTROS INGRESOS Y SUMAR BASE RETENCION
	public function BaseRetencionOtrosIngresos(){
		try{
			$result=array();
			$data=$this->nodeApi->privateApi("/Certificado/Retencion004/OtrosIngresosBaseAD2037",
				array("cedula"=>$this->cedula,"FechaDesde"=>$this->fechadesde,"FechaFin"=>$this->fechafin),"GET");
			

			if ($data["name"]) {
				throw new Exception("Error ".$data);
			}
			$result[0]["BASE_Retencion"]=$data[0][0]["BASE_Retencion"];
			$result[0]["INTeres_ah"]	=$data[1][0]["INTeres_ah"];

			return $result;

		}catch(Exception $e){
			$this->error=$e->getMessage();
		}

	}



	
	public function __get($variable){
		if(property_exists($this,$variable)){
			return $this->$variable;	
		}
		return NULL;
	}
	
}
?>