<?php
session_start();
require_once "../vendor/autoload.php";
require_once("../libreria/php/tcpdf/tcpdf.php");
require_once "../includes_generales/configuracionGeneral.php";
date_default_timezone_set('America/Bogota');
setlocale(LC_TIME,"");

$entidad= "COOPERATIVA DE AHORRO Y CR&Eacute;DITO DE EMPLEADOS DEL SECTOR FINANCIERO";
$gerente= "HENRY V&Eacute;LEZ OSORIO";
$nit = '800023773-6';
$obj=new Asociado($_SESSION["CEDULA"]);


$fechaActa=substr($obj->__get("fechaacta"),0,10);
$fechaIngreso=substr($obj->__get("fechaingreso"),0,10);
$fechaIngreso=$fechaActa!="1900-01-01"?$fechaActa:$fechaIngreso;

$mesLetra=utf8_encode(ucwords(strtolower(strftime("%B"))));

$pdf = new TCPDF('P','mm','letter',true,'UTF-8',false);//P- Alineacion vertical, mm- Medidas en milimetros, A4- Tama�o de la hoja, unicode- define que el texto es unicode, UTF-8- codificacion de la pagina, diskcache- manejo de la cache
$pdf->SetCreator(PDF_CREATOR);//Define el metodo creador del archivo
$pdf->SetAuthor($entidad);//Define el autor del archivo
$pdf->SetTitle("Certificado Afiliacion");//Define el titulo del certificado
$pdf->SetSubject("Certificados ".$entidad);//Es una descripcion general del archivo
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);//Datos del encabezado del documento
$pdf->SetMargins(30,35,30);//Margenes del documento - izquierda, arriba, derecha
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);//Definir salto de pagina automatico
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);//Tama�o a escala para las imagenes incluidas en el documento
$pdf->setPrintHeader(false);//Quitar barra
//Define el lenguaje del documento
if (@file_exists(dirname(__FILE__).'/lang/spa.php')) {
	require_once(dirname(__FILE__).'/lang/spa.php');
	$pdf->setLanguageArray($l);
}

//Agregar Pagina
$pdf->AddPage();

$html= "";
$pdf->Image("img/logo.png",75,15);
$html.= "<br/><br/><br/><br/><br/>";
$html.= '<p style="font-family:Arial;font-size:10pt;text-align:center;"><b><center>'.$entidad.'<br> NIT '.$nit.'<br> CL 51 # 48-09 OF 709 MEDELLIN - ANTIOQUIA Tel 4809480 </center></b><br><br><br><br>';
$html.= '<center>HACE&nbsp;&nbsp;CONSTAR QUE:</center></p>';
$pdf->writeHTML(utf8_encode($html), true, false, true, false, 'C');
$html = "<br><br><br>";
$html.= '<p style="text-align:justify;font-family:Arial;font-size:10pt">El (la) Se&ntilde;or(a) <strong>'.$obj->__get("nombreintegrado").'</strong>, identificado(a) con la c&eacute;dula de ciudadan&iacute;a ';
$html.= 'n&uacute;mero <strong>'.$obj->__get("cedulasociado").'</strong>, se encuentra Asociado(a) a la <strong>'.$entidad.'</strong>, '; 
$html.= 'desde el '.$fechaIngreso;
$html.= ".<br><br><br>";
$html.= 'Esta constancia se expide a petici&oacute;n del interesado(a) el d&iacute;a '.fechaActual();
$html.= ".<br><br><br>";
$html.= "Cordialmente";
$html.= "<br><br><br><br><br><br><br><br><br><br>";
$html.= "";
$html.= "<br>";
$html.= "<strong>".$gerente."</strong><br>Gerente General</p>";
$pdf->Image("img/firma_Gerente_HenryVelezOsorio.png",10,150); 	///////////////////   COLOCAR LA FIRMA
$html.='<p style="font-family:Arial;font-size:10pt;text-align:center;">Para cualquier confirmaci&oacute;n y consulta con respecto al presente certificado, comunicarse a los tel&eacute;fonos (4) 4809480 EXT 111 o 3148909580</p>';
//$pdf -> WriteHTML(utf8_decode($html));
$pdf->writeHTML(utf8_encode($html), true, false, true, false, '');
//Mostrar el documento  - nombre, I- Visualizar, D- Descargar
$pdf -> Output('Cert_Afiliacion.pdf','I');
?>