---
layout: transform
title: Pack Transform
permalink: /docs/transforms/pack/index.html
---

The **pack** transform computes an enclosure diagram that uses containment (nesting) to represent a hierarchy. The size of the leaf circles encodes a quantitative dimension of the data. The enclosing circles show the approximate cumulative size of each subtree, but due to wasted space there is some distortion; only the leaf nodes can be compared accurately.

Internally, this transform processes a collection of special tree node objects generated by an upstream [nest](../nest) or [stratify](../stratify) transform. The original input data object can be accessed under the `data` field of these tree node objects. This transform uses the [d3-hierarchy library](https://github.com/d3/d3-hierarchy).

## Example

{% include embed spec="pack" %}

## Transform Parameters

| Property            | Type                           | Description   |
| :------------------ | :----------------------------: | :------------ |
| field               | {% include type t="Field" %}   | The data field corresponding to a numeric value for the node. The sum of values for a node and all its descendants is available on the node object as the `value` property. If _radius_ is `null`, this field determines the node size.|
| sort                | {% include type t="Compare" %} | A comparator for sorting sibling nodes. The inputs to the comparator are tree node objects, not input data objects.|
| size                | {% include type t="Number[]" %}| The size of the layout, provided as a [width, height] array.|
| radius              | {% include type t="Field" %}   | An explicit node radius to use. If `null` (the default), the radius of each leaf circle is derived from the _field_ value.|
| padding             | {% include type t="Number" %}  | The approximate padding to include between packed circles (default `0`).|
| as                  | {% include type t="String[]" %}| The output fields at which to write the layout results. The default is `["x", "y", "r", "depth", "children"]`, where `x` and `y` are the layout coordinates, `r` is the node radius, `depth` is the tree depth, and `children` is the count of a node's children in the tree.|

## Usage

```json
{
  "type": "pack",
  "field": "value",
  "padding": 4,
  "size": [{"signal": "width"}, {"signal": "height"}]
}
```

Computes a pack layout with `4` pixel padding between nodes, using the full width and height of the view. Leaf nodes are sized proportionally to the `value` field.
