angular
    .module("modRenCancAhorro", ["ngRoute"])
    .config(function($routeProvider) {
        $routeProvider
            .when("/", {
                templateUrl: "vista/view_renovar_cancelar.html",
                controller: "ctrRenCancAhorro"
            })
            .otherwise({
                templateUrl: "vista/view_renovar_cancelar.html",
                controller: "ctrRenCancAhorro"
            });
    })
    .factory("$factory", function() {
        var obj = {
            valResp: function(res) {
                try {
                    if (res.status == 404) {
                        //throw { message: "Servicio no encontrado" };
                        location.href =
                            "../includes_generales/salida_segura.php";
                    }
                    if (res.data.message != undefined) throw res.data;
                    if (res.data.estado != undefined && !res.data.estado)
                        throw { message: res.data.msj };
                    cerrarCargando();
                    return { estado: true };
                } catch (err) {
                    cerrarCargando();
                    return { estado: false, msj: err.message };
                }
            }
        };
        return obj;
    })
    .service("$srvAhorroRenCanc", [
        "$http",
        function($http) {
            this.ahorrosAvAc = function() {
                CargandoMostrar();
                return $http({
                    method: "POST",
                    url: "ctr/ctr_renovar_cancelar.php",
                    data: { caso: 1 },
                    header: {
                        "Content-Type": "application/json"
                    }
                });
            };

            this.ahorroRenovarCancelar = function(datos) {
                datos.caso = 2;
                CargandoMostrar();
                return $http({
                    method: "POST",
                    url: "ctr/ctr_renovar_cancelar.php",
                    data: datos,
                    header: {
                        "Content-Type": "application/json"
                    }
                });
            };
        }
    ])
    .controller("ctrRenCancAhorro", [
        "$scope",
        "$srvAhorroRenCanc",
        "$factory",
        function($scope, $srv, $factory) {
            //Productos
            $scope.sltAhorros = [];
			
			//Creditos
            $scope.creditos = [];
			
			//Informacion bancaria
            $scope.infoBanco = [];

            //Producto seleccionado
            $scope.ahorroSelected;
			$scope.datos={};
			
			//$scope.lineaAhorro=[];
			
			//$scope.cuota=0;

            $scope.response = undefined;

            $srv.ahorrosAvAc().then(
                function(res) {
                    var valResp = $factory.valResp(res);
					//console.log(res.data);
                    if (!valResp["estado"]) {
                        $scope.response = valResp;
                    }
                    $scope.response = res.data;
                    if ($scope.response.estado) {
                        $scope.sltAhorros = $scope.response.ahorros;
						$scope.creditos = $scope.response.creditos;
						$scope.infoBanco = $scope.response.infoBanco;
						var combosACargar	=	"14,,cbbbancoRC,"+$scope.infoBanco.banco+"";
						CargarCombos(combosACargar);
                    }
                },
                function(err) {
                    $scope.response = $factory.valResp(err);
                }
            );

            $scope.submit = function() {
				$scope.infoBanco.banco=$("#cbbbancoRC").val();
				if($scope.queEs=='C'){
					$scope.cuota=0;
				}

				var data = {
                    queEs				: $scope.queEs,
                    codlinea			: $scope.ahorroSelected.codlinea,
                    numerocuenta		: $scope.ahorroSelected.numerocuenta,
                    cuota				: $scope.cuota,
					disponersaldo		: $("#DisponerSaldo").val()+'|'+$("#DisponerSaldo option:selected").text(),
					coddestino			: $scope.datos.coddestino,
					pagare				: $scope.datos.pagare,
					saldo				: $scope.datos.saldo,
					numerocuentabanco	: $scope.infoBanco.numerocuenta,
					tipocuenta			: $scope.infoBanco.tipocuenta,
					banco				: $scope.infoBanco.banco,
                };
				
				if($scope.queEs=='R'){
					var msj="renovación";
				}
				else{
					var msj="cancelación";
				}
				
				if($scope.DisponerSaldo=='4'){
					data["coddestino"]="";
					data["pagare"]="";
					data["saldo"]="";
				}
				else{
					data["numerocuentabanco"]="";
					data["tipocuenta"]="";
					data["banco"]="";
				}
				
                if (
                    confirm(
                        "Está seguro de solicitar la "+msj+" del ahorro " +
                            $scope.ahorroSelected.namelinea
                    )
                ) {
                    $srv.ahorroRenovarCancelar(data).then(
                        function(res) {
                            var valResp = $factory.valResp(res);
                            if (!valResp["estado"]) {
                                $scope.response = valResp;
                            }
                            $scope.response = res.data;
                        },
                        function(err) {
                            $scope.response = $factory.valResp(err);
                        }
                    );
                }
            };
			
			

            $scope.formatNumero = function() {
                if ($scope.cuota !== undefined) {
                    var aux = $scope.cuota.QuitarCaracter(",");
                    aux = parseInt(aux);
                    $scope.cuota = aux.numberFormat();
                }
            };
        }
    ]);
