<?php
require_once dirname(__FILE__)."/../../vendor/autoload.php";
class AhorroRenovarCancelar{
	
	//Contiene toda la informacion del asociado
	private $objAsociado;
	
	//Contiene toda la informacion del asociado
	private $productos;
	
	//Tipo de accion a realizar
	private	$queEs;
	
	//Linea del ahorro a renovar o cancelar
	private $codlinea;
	
	//Numero de la cuenta del ahorro
	private $numerocuenta;
	
	//Cuota del ahorro si es renovacion
	private	$valorcuota;
	
	//Accion para disponer del ahorro
	private $disponersaldo;
	
	//ID de Accion para disponer del ahorro
	private $idDisponersaldo;
	
	//codigo del destino del credito si va a abonar a creditos
	private $coddestino;

	//Pagare del credito
	private $pagare;

	//Saldo actual del credito
	private $saldo;

	//Numero de cuenta de banco si va a abonar a la cuenta
	private $numerocuentabanco;
	
	//Tipo de la cuenta del banco
	private $tipocuenta;

	//banco a abonar
	private $banco;

	//Fecha de la creacion del ahorro
	private $fecha;
			
	//Conexion al servicio web
	private $nodeApi;
	
	//Variable que utilizaremos como un array para manejar los mensajes y el estado de proceso ejecutado
	private $response;
	
	
	//Contructor del nuevo ahorro, se le debera enviar la cedula del asociado como parametro
	public function AhorroRenovarCancelar($cedula){
		$this->response=array("estado"=>true,"msj"=>"");
		$this->fecha=date('Y/m/d H:i:s');
		try{
			$this->objAsociado=new Asociado($cedula);
			//Si hay un error consultando el asociado lanzamos la excepción
			if($this->objAsociado->getError())throw new Exception("No fue posible consultar los datos del asociado");
			
			$this->nodeApi=new NodeApi();			
			//Si hay un error con la conexion al servicio lanzamos la excepción
			if(!$this->nodeApi->__getEstado())throw new Exception("No fue posible consultar los datos del asociado");
			
			$this->productos 			=new Productos($cedula);
			
			$this->response=array("estado"=>true,"msj"=>"Objeto creado correctamente");
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());			
		}		
	}
	
	//Crea el ahorro
	public function Solicitar(){
		try{
			$consulta=$this->nodeApi->privateApi("/Ahorro/ValidaRenCancPendiente",array("codlinea"=>$this->codlinea,"numerocuenta"=>$this->numerocuenta,"estado"=>"P"),'GET');
			if(count($consulta)>0)throw new Exception("Señor asociado usted ya cuenta con una solicitud de renovación o cancelación pendiente por esta línea de ahorro.");
			
			if($this->codlinea=='')throw new Exception("Debe escoger una linea para continuar");
			if($this->queEs=="R" and $this->valorcuota=='')throw new Exception("Debe ingresar el valor de la cuota para continuar");
			if($this->disponersaldo=="Abonar a mis productos" and $this->coddestino=='')throw new Exception("Debe escoger uno de los creditos enlistados");
			if($this->disponersaldo=="Abonar a mi cuenta" and $this->numerocuentabanco=='')throw new Exception("Debe ingresar el numero de la cuenta para continuar");
			if($this->disponersaldo=="Abonar a mi cuenta" and $this->tipocuenta=='')throw new Exception("Debe escoger un tipo de cuenta para continuar");
			if($this->disponersaldo=="Abonar a mi cuenta" and $this->banco=='0')throw new Exception("Debe escoger un banco para continuar");
			
			$Valores=$this->nodeApi->publicApi("/Productos/Ahorros",array("tipo"=>'AC'),'GET');
			if($this->queEs=="R"){
				if($this->valorcuota<$Valores[0][0]["valorminimo"])throw new Exception("El valor de la cuota debe ser mayor o igual a $".number_format($Valores[0][0]["valorminimo"]));
				if($this->valorcuota>$Valores[0][0]["valormaximo"])throw new Exception("El valor de la cuota no puede superar $".number_format($Valores[0][0]["valormaximo"]));
			}
			
			/*$resultado=$this->nodeApi->privateApi("/Ahorro/ValidaSolLiquidacion",array("cedula"=>$this->objAsociado->__get('cedulasociado'),"codlinea"=>$this->codlinea,"estado"=>"A"),"GET");
			//$anoSol = substr($resultado[0][0]["fechaSolicitud"],0,4);
			$anoSol = substr("2019-01-15",0,4);
			if($anoSol==date("Y"))throw new Exception("Ya realizo una solicitud por el año vigente");
			
			exit;*/
			$result=$this->nodeApi->privateApi("/Ahorro/RenovarCancelar",
				array("cedula"=>$this->objAsociado->__get('cedulasociado'),
					"queEs"=>$this->queEs,
					"codlinea"=>$this->codlinea,
					"numerocuenta"=>$this->numerocuenta,
					"valorcuota"=>$this->valorcuota,
					"disponersaldo"=>$this->disponersaldo,
					"idDisponersaldo"=>$this->idDisponersaldo,
					"coddestino"=>$this->coddestino,
					"pagare"=>$this->pagare,
					"saldocapital"=>$this->saldo,
					"numerocuentabanco"=>$this->numerocuentabanco,
					"tipocuenta"=>$this->tipocuenta,
					"codbanco"=>$this->banco,
					"estado"=>"P",
					"fechaSolicitud"=>$this->fecha)
			,"POST");
			
			if(count($result)>0)throw new Exception("No fue posible enviar la solicitud");
			
			$this->response=array("estado"=>true,"msj"=>"Solicitud realizada correctamente");

		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());	
		}		
	}


	/**
	 * Consulta ahorros a la vista y ahorros contractuales para llenar el combo en la vista
	 */
	public function ahorrosAvAc(){
		try{
			$result=$this->productos->AportesAhorros();
			if(is_null($result))throw new Exception("No fue posible consultar los ahorros");			
		
			if(count($result)<=0)throw new Exception("No tiene productos para el cambio de Ahorros");	
			$result=$result[0];
			$tam=count($result);
			$registros = array();
			
			$tipoAhorrosDispo=$this->tiposAhorrosPermitidos();
			$tamTipoAhorrosDispo=count($tipoAhorrosDispo);
			for($i=0;$i<$tam;$i++){
				//Filtrar los ahorros a mostrar
				if($result[$i]["quees"]=='AHORRO'){
					//Buscamos que la linea si se encuentre en los ahorros permitidos para cambio de cuota
					for($k=0;$k<$tamTipoAhorrosDispo;$k++){
						if(trim($result[$i]["codlinea"])==trim($tipoAhorrosDispo[$k]["lineaahorros"])){
							$result[$i]['tipo']=$tipoAhorrosDispo[$k]["tipoahorro"];
							//Validamos que el ahorro tenga saldo mayor o igual a 0
							if($result[$i]['saldoTotal']>=0 and $result[$i]['tipo']=='AC'){
								$arrayAux=array("codlinea"=>$result[$i]["codlinea"],"numerocuenta"=>$result[$i]["numerocuenta"]);			
								
								$result[$i]["interes"]=(int)$result[$i]["interes"];
								$registros[]=$result[$i];
								break;
							}
						}
					}
				}
			}
			$this->response=array("estado"=>true);
			return $registros;
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}
	
	public function tiposAhorrosPermitidos(){
		try{
			$respuesta=$this->nodeApi->privateApi("/Ahorro/tiposAhorrosPermitidos",array("cedula"=>$this->asociado->cedulasociado),"GET");
			
			if(is_null($respuesta)) throw new Exception("No fue posible consultar las tipos de ahorros disponibles");

			$this->response=array("estado"=>true,"msj"=>"Consulta de lineas ahorros correctamente");

			return $respuesta;
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
			return null;
		}
	}
	
	public function ProductosCreditos(){
		try{
			$result=$this->productos->Creditos();
			if(is_null($result))throw new Exception("No fue posible consultar los ahorros");			
		
			if(count($result)<=0)throw new Exception("No tiene productos para el cambio de Ahorros");	
			$result=$result[0];
			$tam=count($result);
			$registros = array();

			for($i=0;$i<$tam;$i++){
				//Filtrar los creditos a mostrar
				if($result[$i]["quees"]=='CREDITO'){
					//Validamos que el credito tenga saldo mayor a 0
					if($result[$i]['saldo']>0){
						$registros[]=$result[$i];
					}
				}
			}
			//$this->response=array("estado"=>true,"data"=>$registros);
			return $registros;
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
			return null;
		}
	}
	
	public function InfoBancaria(){
		try{
			//$registros=array();
			$numerocuenta 	= $this->objAsociado->__get('numerocuenta');
			$tipocuenta 	= $this->objAsociado->__get('tipocuenta');
			$banco 			= $this->objAsociado->__get('codbanco');
			
			if(is_null($this->objAsociado))throw new Exception("No fue posible consultar los ahorros");			

			
			$registros=array("numerocuenta"=>trim($numerocuenta),"tipocuenta"=>trim($tipocuenta),"banco"=>trim($banco));
			
			//$this->response=array("estado"=>true,"data"=>$registros);
			return $registros;
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
			return null;
		}
	}

	public function getResponse(){
		return $this->response;
	}
	
	public function __set($variable,$valor){
		if(property_exists($this,$variable)){
			$this->$variable=$valor;
		}
	}
	
	public function __get($variable){
		if(property_exists($this,$variable)){
			return $this->$variable;
		}
		return NULL;
	}	

}
?>