angular
    .module("modCrearAhorro", ["ngRoute"])
    .config(function($routeProvider) {
        $routeProvider
            .when("/", {
                templateUrl: "vista/view_crear.html",
                controller: "ctrCrearAhorro"
            })
            .otherwise({
                templateUrl: "vista/view_crear.html",
                controller: "ctrCrearAhorro"
            });
    })
    .factory("$factory", function() {
        var obj = {
            valResp: function(res) {
                try {
                    if (res.status == 404) {
                        //throw { message: "Servicio no encontrado" };
                        location.href =
                            "../includes_generales/salida_segura.php";
                    }
                    if (res.data.message != undefined) throw res.data;
                    if (res.data.estado != undefined && !res.data.estado)
                        throw { message: res.data.msj };
                    cerrarCargando();
                    return { estado: true };
                } catch (err) {
                    cerrarCargando();
                    return { estado: false, msj: err.message };
                }
            }
        };
        return obj;
    })
    .service("$srvAhorroCrear", [
        "$http",
        function($http) {
            this.ahorrosAvAc = function() {
                CargandoMostrar();
                return $http({
                    method: "POST",
                    url: "ctr/ctr_crear_ahorro.php",
                    data: { caso: 1 },
                    header: {
                        "Content-Type": "application/json"
                    }
                });
            };

            this.ahorroCrear = function(datos) {
                datos.caso = 2;
                CargandoMostrar();
                return $http({
                    method: "POST",
                    url: "ctr/ctr_crear_ahorro.php",
                    data: datos,
                    header: {
                        "Content-Type": "application/json"
                    }
                });
            };
        }
    ])
    .controller("ctrCrearAhorro", [
        "$scope",
        "$srvAhorroCrear",
        "$factory",
        function($scope, $srv, $factory) {
            //Productos
            $scope.sltAhorros = [];

            //Producto seleccionado
            $scope.ahorroSelected;

            $scope.plazo = 0;

            $scope.response = undefined;
            //se ejecuta la funcion para traer los ahorros
            $srv.ahorrosAvAc().then(
                function(res) {
					//console.log(res.data.data[0]);
                    var valResp = $factory.valResp(res);
					
                    if (!valResp["estado"]) {
                        $scope.response = valResp;
                    }
                    $scope.response = res.data;
                    if ($scope.response.estado) {
                        $scope.sltAhorros = $scope.response.data;
						//console.log($scope.sltAhorros.namelinea);
                    }
                },
                function(err) {
                    $scope.response = $factory.valResp(err);
                }
            );

            $scope.submit = function() {
				//console.log($scope.ahorroSelected.tipo);
                //$scope.plazo = $scope.ahorroSelected.tipo === "AC" ? $scope.plazo : 0;
                $scope.plazo=0;
			
                var data = {
                    codLinea: $scope.ahorroSelected.codlinea,
                    tipo: $scope.ahorroSelected.tipo,
                    cuota: $scope.cuota,
                    plazo: $scope.plazo
                };
                if (
                    confirm(
                        "Está seguro de crear un ahorro " +
                            $scope.ahorroSelected.nombrelinea.trim()+
                            " con cuota " +
                            $scope.cuota
                    )
                ) {
                    $srv.ahorroCrear(data).then(
                        function(res) {
                            var valResp = $factory.valResp(res);
                            if (!valResp["estado"]) {
                                $scope.response = valResp;
                            }
                            $scope.response = res.data;
                        },
                        function(err) {
                            $scope.response = $factory.valResp(err);
                        }
                    );
                }
            };

            $scope.formatNumero = function() {
                if ($scope.cuota !== undefined) {
                    var aux = $scope.cuota.QuitarCaracter(",");
                    aux = parseInt(aux);
                    $scope.cuota = aux.numberFormat();
                }
            };
        }
    ]);
