<?php
require_once dirname(__FILE__)."/../../vendor/autoload.php";
class AhorroCrear{
	
	//Contiene toda la informacion del asociado
	private $objAsociado;	
	
	//Cuota del nuevo ahorro
	private	$valorCuota;
	
	//Linea del ahorro a crear
	private $codLinea;
	
	//Numero de la cuenta
	private $numCuenta;
	
	//Tipo del ahorro : Ahorros a la vista o Ahorros Contractual
	private $tipoAhorro;
	
	//Fecha de la creacion del ahorro
	private $fecha;
			
	//Conexion al servicio web
	private $nodeApi;
	
	//Variable que utilizaremos como un array para manejar los mensajes y el estado de proceso ejecutado
	private $response;

	//Tasa efectiva con la cual se va crear el ahorro
	private $tasaEfectiva;

	//Plazo
	private $plazo;
	
	//Productos del asociado
	private $productos;
	
	
	//Contructor del nuevo ahorro, se le debera enviar la cedula del asociado como parametro
	public function AhorroCrear($cedula){
		$this->response=array("estado"=>true,"msj"=>"");
		$this->fecha=date('Y/m/d H:i:s');
		try{
			$this->objAsociado=new Asociado($cedula);
			//Si hay un error consultando el asociado lanzamos la excepción
			if($this->objAsociado->getError())throw new Exception("No fue posible consultar los datos del asociado");
			
			$this->nodeApi=new NodeApi();			
			//Si hay un error con la conexion al servicio lanzamos la excepción
			if(!$this->nodeApi->__getEstado())throw new Exception("No fue posible consultar los datos del asociado");
			
			$this->productos = new Productos($cedula);
			
			$this->response=array("estado"=>true,"msj"=>"Objeto creado correctamente");
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());			
		}		
	}
	
	//Crea el ahorro
	public function crearAhorro(){
		try{
			if(trim($this->codLinea)=='3'){
				$resultado=$this->nodeApi->privateApi("/Ahorro/ValidaSolLiquidacion",array("cedula"=>$this->objAsociado->__get('cedulasociado'),"codlinea"=>$this->codLinea,"estado"=>"P"),"GET");
				$dataProd=$this->productos->AportesAhorros();
				$dataProd=$dataProd[0];
				$tam=count($dataProd);
				for($i=0;$i<$tam;$i++){
					if(trim($dataProd[$i]["codlinea"])=='3' or $resultado){
						throw new Exception("No se puede crear el ahorro navideño dado que tiene uno vigente y debe renovarlo o esta en proceso de renovacion");	
					}
				}
			}

			$ValorMinimo=$this->ahorrosAvAc();
			//var_dump($this->response);exit;
			//$this->response["data"]["valorminimo"]
			for($i=0; $i<count($this->response["data"]); $i++){
				$campo=$this->response["data"][$i];
				if($this->codLinea==$campo["codlinea"]){
					if($this->valorCuota<$campo["valorminimo"])throw new Exception("El valor de la cuota debe ser mayor o igual a $".number_format($campo["valorminimo"]));
					if($this->valorCuota>$campo["valormaximo"])throw new Exception("El valor de la cuota no puede superar $".number_format($campo["valormaximo"]));
				}
			}
			
			if($this->consecutivo()===false)throw new Exception("No fue posible generar el consecutivo del ahorro");
			$Tasa=$this->consultarTasa();
			if($Tasa['estado']===false)throw new Exception($Tasa['msj']);

			$result=$this->nodeApi->privateApi("/Ahorro/Crear",
				array("cedula"=>$this->objAsociado->__get('cedulasociado'),
					"codLinea"=>$this->codLinea,
					"numeroCuenta"=>$this->numCuenta,
					"ValorCuotaAhorro"=>$this->valorCuota,			
					"tipoAhorro"=>$this->tipoAhorro,
					"tasaEfectiva"=>$this->tasaEfectiva,
					"plazo"=>$this->plazo)
			,"POST");
			
			if(count($result)>0)throw new Exception("No fue posible crear el ahorro");
			
			$this->response=array("estado"=>true,"msj"=>"Ahorro creado correctamente");

		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());	
		}		
	}


	/**
	 * Consulta ahorros a la vista y ahorros contractuales para llenar el combo en la vista
	 */
	public function ahorrosAvAc(){
		try{
			//Consulta de ahorros a la vista
			$result1=$this->nodeApi->publicApi("/Productos/Ahorros",array("tipo"=>'AV'),'GET');
			
			if(!isset($result1[0]))throw new Exception("Error consultando ahorros a la vista");

			//Consulta ahorros contractuales
			$result2=$this->nodeApi->publicApi("/Productos/Ahorros",array("tipo"=>'AC'),'GET');

			if(!isset($result2[0]))throw new Exception("Error consultando ahorros contractuales");
			
			//OJO: Si cambia las fechas de rango tambien debe cambiar las fechas en el controlador ctr_crear_ahorro
			//OJO: Si cambia las fechas de rango tambien debe cambiar las fechas en el controlador ctr_crear_ahorro
			$CorteINI = "01-11-";
			$CorteFIN = "31-05-";

			$fechaActual	= strtotime(date("d-m-Y"));
			$fechamayo		= strtotime($CorteFIN.date("Y"));
			
			if($fechaActual<=$fechamayo)
			{
				$rango1 		= strtotime($CorteINI.(date("Y")-1));
				$rango2			= strtotime($CorteFIN.date("Y"));
			}
			else
			{
				$rango1 		= strtotime($CorteINI.date("Y"));
				$rango2			= strtotime($CorteFIN.(date("Y")+1));
			}

			if($fechaActual>=$rango1 and $fechaActual<=$rango2){
				$result=array_merge($result1[0],$result2[0]);
			}
			else{
				$result=array_merge($result1[0]);
			}
			
			
			$this->response=array("estado"=>true,"data"=>$result);
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}

	/**
	 * Consulta el consecutivo para asignar a linea de ahorros a crear
	 */
	private function consecutivo(){
		try{
			//Consulta la linea
			$result=$this->nodeApi->privateApi("/Ahorro/Crear/Consecutivo",
			array("cedula"=>$this->objAsociado->__get('cedulasociado'),"tipoAhorro"=>$this->tipoAhorro,"codLinea"=>$this->codLinea),'GET');
			
			if(!isset($result[0][0]["numeroCuenta"]))throw new Exception("No fue posible consultar el consecutivo");

			$this->numCuenta=$result[0][0]["numeroCuenta"];

			return true;
		}
		catch(Exception $e){
			return false;
		}	
	}

	/**
	 * Consultar la tasa con la cual se va crear el ahorro
	 */
	private function consultarTasa(){ 
		try{
			//Consulta la linea
			$result=$this->nodeApi->privateApi("/Ahorro/Crear/Tasa",array("tipoAhorro"=>$this->tipoAhorro,"codLinea"=>$this->codLinea,"plazoDias"=>$this->plazo),'GET');
			if(!isset($result[0][0]["tasaEfectiva"]))throw new Exception("No fue posible consultar el consecutivo");
			//if(!isset($result[0][0]["tasaEfectiva"]))throw new Exception($result[0][0]["msj"]);
			$this->tasaEfectiva=$result[0][0]["tasaEfectiva"];

			return true;
			//$this->response=array("estado"=>true,"data"=>$result);
		}
		catch(Exception $e){
			return array("estado"=>false,"msj"=>$result[0][0]["msj"]);
			//$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}	
	}

	public function getResponse(){
		return $this->response;
	}
	
	public function __set($variable,$valor){
		if(property_exists($this,$variable)){
			$this->$variable=$valor;
		}
	}
	
	public function __get($variable){
		if(property_exists($this,$variable)){
			return $this->$variable;
		}
		return NULL;
	}
	
	public function daysdiff ($dt1, $dt2){
		$dt1 = new DateTime($dt1);
		$dt2 = new DateTime($dt2);  
		
		/*if ($dt1->diff($dt1)->format("%a")!= '6015') {
			return $dt1->diff($dt2)->format("%a");
		}*/
		
		$y1 = $dt1->format('Y');  
		$y2 = $dt2->format('Y');
		$z1 = $dt1->format('z');
		$z2 = $dt2->format('z');
		
		$diff = intval($y1 * '360' + $z1) - intval($y2 * '360' + $z2);
		
		return $diff;
	}

}
?>