angular.module("CambioCuotaAhorros",[])
.factory("$validar",function(){
	var obj={
		checkData:function(data){
				try{
					//Comprueba que la data sea valida
					if(data==undefined || data==false )throw 'Error en la data';
					//Comprueba el codigo de estado del servidor
					if(data.status!=200)throw 'Error en la solicitud';
					//Comprueba si el servicio retornó algun mensaje de error
					if(data.data.message!=null)throw data.data.message;
					
					return true;
				}
				catch(err){
					salidaSegura();
					return false;
				}	
		}
	}
	return obj;
})
.controller("ctrCambioCuotaAhorros",["$scope","$http","$interval","$validar",function($scope,$http,$interval,$validar){
	
	//Productos a mostrar
	$scope.productos=[]

	//Datos del producto a modificar
	$scope.producto={};

	//Respuestas 
	$scope.response=[];	
	
	//Consultar productos disponibles para devolucion de ahorros
	$scope.getProductos=function(){
		CargandoMostrar();
		$http({
			method:'POST',
			url:'ctr/ctr_cambiar.php',
			data:{'caso':1}
		}).then(
			function success(res){
				try{
					$validar.checkData(res);
					$scope.productos=res.data.productos;
					
					if($scope.productos.length==0){
						$scope.response={
							estado:false,
							msj:"No hay ningun producto disponibles"
						}
					}
					$scope.validarSiDebeEsperarParaCambio();
				}
				catch(err){
					$scope.response=res.data;
				}
				finally{
					cerrarCargando();
				}								
			},
			function error(err){
				$validar.checkData(err);
				$scope.response={
						estado:false,
						msj:"No fue posible realizar la petición solicitada"
					}
				cerrarCargando();
			}
		)
	}

	$scope.getProductos();

	$scope.cambiar=function(producto){
		
		$scope.response=[];
		$scope.cuotaNew="";
		$scope.producto=producto;
	}

	$scope.alerta=function(){
		$scope.response={
			estado:false,
			msj:"Para realizar un cambio de cuota al producto seleccionado deberá esperar hasta la fecha que allí se le muestra, según los lineamientos que se tienen establecidos por la entidad."
		}
	}

	$scope.solicitar=function(){		
		var datos=$scope.producto;
		datos["caso"]=2;
		datos["cuotaNew"]=$scope.cuotaNew;
		var cuotaSinComas=$scope.cuotaNew.ReplaceAll(',','');
		if(isNaN(cuotaSinComas) || cuotaSinComas==''){
			$scope.response={
				estado:false,
				msj:"Cuota ingresada no valida"
			}
			$('#myModal').modal('hide')
			return;
		}
		/*console.log(datos);
		return;*/
		CargandoMostrar();
		$http({
			method:'POST',
			url:'ctr/ctr_cambiar.php',
			data:datos
		}).then(
			function success(res){
				try{
					$validar.checkData(res);
					$('#myModal').modal('hide')

					var data=res.data
					$scope.response=data;

					//Si cambio la cuota, recargo los productos
					if($scope.response.estado){
						$scope.getProductos();					
					}
				}
				catch(err){
					$scope.response={
						estado:false,
						msj:"Error ejecutando procedimiento por favor comuniquese con la entidad"
					}
				}
				finally{
					cerrarCargando();
				}
			},
			function error(err){
				$validar.checkData(err);
				$('#myModal').modal('hide')
				$scope.response={
					estado:false,
					msj:"Error ejecutando procedimiento por favor comuniquese con la entidad"
				}
				cerrarCargando();
			}
		)
	}

	//Executar contador de tiempo para cada producto
	$scope.validarSiDebeEsperarParaCambio=function(){		
		
		angular.forEach($scope.productos,function(element,key){
			
			element.fechaHasta=false;
			if(element.tiempoFaltante>0){
				//Milisegundos faltantes para permitir proximo cambio de cuota
				var milisegundosFaltantes=element.tiempoFaltante*60*1000
				element.fechaHasta=new Date(new Date().getTime()+milisegundosFaltantes);
			}

		});
	}

	$scope.dateFormat=function(date){
		
		var year=date.getFullYear(),
			 month=date.getMonth()+1,
			 day=date.getDate(),
			 hh=date.getHours(),
			 min=date.getMinutes(),
			 second=0
		
		if(month<=9)
			month ="0"+month;
		if(day<=9)
			day ="0"+day;
		if(hh<=9)
			hh ="0"+hh;
		if(min<=9)
			min ="0"+min;
		if(second<=9)
			second ="0"+second;
		
		var fecha=day+"/"+month+"/"+year+" "+hh+":"+min+":"+second
		return fecha;
	}

}])

$(function(){
	var cuota_new=$("#cuota-new");
	
	cuota_new.keypress(function(evt){
			var charCode = (evt.which) ? evt.which : event.keyCode;
			if (charCode > 31 && (charCode < 48 || charCode > 57))
		 		return false;

			return true;
	})
	cuota_new.keyup(function(){this.value=ColocarComas(this.value)})
	cuota_new.keydown(function(){this.value=ColocarComas(this.value)})
})