<?php
require_once dirname(dirname(dirname(__FILE__)))."/vendor/autoload.php";

class CambioCuotaAhorros{

	protected 	$asociado,
				$productos,
				$linea,
				$nroCuenta,
				$valorCuotaNew,
				$fechaActualizacion,
				$response;
				

	protected $nodeApi;
	
	public function CambioCuotaAhorros($cedula,$linea="",$numCuenta="",$valorCuotaCambio=""){		
		$this->linea 				=trim($linea);
		$this->nroCuenta 			=trim($numCuenta);
		$this->valorCuotaNew 		=$valorCuotaCambio;
		$this->fechaActualizacion 	=date("Y/m/d H:i:s");
		$this->nodeApi				=new NodeApi(false);
		$this->asociado 			=new Asociado($cedula);
		$this->productos 			=new Productos($cedula);

		if(!$this->nodeApi->__getEstado()){
			$this->response=array("estado"=>false,"msj"=>"No fue posible establecer conexion con el servicio web");
		}
		else{
			$this->response=array("estado"=>true,"msj"=>"Conexión realizada con exito");
		}
	}
	
	//Retorna los productos disponibles para el cambio de cuota de ahorros
	public function productosDisponibles(){
		try{
			$result=$this->productos->AportesAhorros();
			if(is_null($result))throw new Exception("No fue posible consultar los ahorros");			
		
			if(count($result)<=0)throw new Exception("No tiene productos para el cambio de Ahorros");

			$ahorrosDeshabilitar=$this->ahorrosParaDeshabilitar();		
			
			$vecTiempoFaltante 	=$ahorrosDeshabilitar[1];
			$ahorrosDeshabilitar =$ahorrosDeshabilitar[0];
			
			$result=$result[0];
			
			$tam=count($result);

			$registros = array();
			//$datos = array();
			
			$tipoAhorrosDispo=$this->tiposAhorrosPermitidos();
			$periodoDeduccionTexto=periodoDeduccionLetraATexto($this->asociado->periododeduce);
			$LineasPermanentes=$this->LineasPermanentes();
			//var_dump($this->LineasPermanentes());
			//var_dump($tipoAhorrosDispo);
			$tamTipoAhorrosDispo	= count($tipoAhorrosDispo);
			$tamLineasPermanentes	= count($LineasPermanentes);
			$agrupa=0;
			$sumacuota=0;
			$sumatotal=0;
			$sumainteres=0;
			$cont=0;
			
			for($k=0;$k<$tamLineasPermanentes;$k++){
				
				for($i=0;$i<$tam;$i++){
					
					//Filtrar los ahorros a mostrar
					if($tipoAhorrosDispo[$i]["tipoahorro"]=='PO' or $tipoAhorrosDispo[$i]["tipoahorro"]=='AP'){
						//Buscamos que la linea si se encuentre en los ahorros permitidos para cambio de cuota
						if(trim($LineasPermanentes[$k]['codLinea'])==trim($result[$i]["codlinea"])){
							//var_dump($result[$i]);
							$arrayAux=array("codlinea"=>$result[$i]["codlinea"],"numerocuenta"=>$result[$i]["numerocuenta"]);
							
							$posAxu=array_search($arrayAux,$ahorrosDeshabilitar);
							
							$result[$i]["tiempoFaltante"]=0;
							
							$result[$i]["periodoDeduccion"]=$periodoDeduccionTexto;
							if($posAxu!==false){//SI EL AHORRO A MOSTRAR HAY QUE DESHABILITARLO
								$result[$i]["tiempoFaltante"]=$vecTiempoFaltante[$posAxu];
							}
							
							$result[$i]["interes"]=(int)$result[$i]["interes"];
							$result[$i]["namelinea"]='AHORRO MENSUAL';
							$sumacuota=$sumacuota+$result[$i]["valorcuota"];
							$result[$i]["valorcuota"]=$sumacuota;
							$sumatotal=$sumatotal+$result[$i]["saldoTotal"];
							$result[$i]["saldoTotal"]=$sumatotal;
							$sumainteres=$sumainteres+$result[$i]["interes"];
							$result[$i]["interes"]=$sumainteres;
							$result[$i]['fechainicio']=$result[0]['fechainicio'];
							
							if($tamLineasPermanentes>=2){
								$result[$i]['codlinea']=substr(trim($LineasPermanentes[0]['codLinea']).','.trim($LineasPermanentes[1]['codLinea']),0,3);
								$result[$i]['tipoahorro']=$tipoAhorrosDispo[0]["tipoahorro"].','.$tipoAhorrosDispo[1]["tipoahorro"];
							}
							else{
								$result[$i]['codlinea']=trim($LineasPermanentes[$k]['codLinea']);
								$result[$i]['tipoahorro']=$tipoAhorrosDispo[$k]["tipoahorro"];
							}
							
							$datos = array($cont=>$result[$i]);
							//var_dump($datos);
							//var_dump($datos);
							if($tamLineasPermanentes>=2){
								$registros[]=$datos[1];
								$registros=array_filter($registros);
							}
							else{
								$registros[]=$result[$i];
							}
							//var_dump($registros);
						}
					}
				}
				$cont++;
			}
			//var_dump($registros);
			for($i=0;$i<$tam;$i++){
				if($tipoAhorrosDispo[$i]["tipoahorro"]=='AC' or $tipoAhorrosDispo[$i]["tipoahorro"]=='AV'){
				
					//Buscamos que la linea si se encuentre en los ahorros permitidos para cambio de cuota
					for($k=0;$k<$tamTipoAhorrosDispo;$k++){
						//var_dump($tipoAhorrosDispo[$k]);
						if(trim($tipoAhorrosDispo[$k]["lineaahorros"])==trim($result[$i]["codlinea"])){
							
							$arrayAux=array("codlinea"=>$result[$i]["codlinea"],"numerocuenta"=>$result[$i]["numerocuenta"]);
							
							$posAxu=array_search($arrayAux,$ahorrosDeshabilitar);
							
							$result[$i]["tiempoFaltante"]=0;
							
							$result[$i]["periodoDeduccion"]=$periodoDeduccionTexto;
							if($posAxu!==false){//SI EL AHORRO A MOSTRAR HAY QUE DESHABILITARLO
								$result[$i]["tiempoFaltante"]=$vecTiempoFaltante[$posAxu];
							}					
							
							$result[$i]['tipoahorro']=$tipoAhorrosDispo[$k]["tipoahorro"];
							$result[$i]["interes"]=(int)$result[$i]["interes"];
							
							$registros[]=$result[$i];
							
							//break;
						}
					}
				}
			}
			$this->response=array("estado"=>true,"msj"=>"productos consultados correctamente");
			return $registros;
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}

	public function actualizarCuota($cuotaOld,$cuotaNew,$codlinea,$namelinea,$tipoahorro){
		try{
			$cuotaNew=str_replace(",","",$cuotaNew);
			if(!is_numeric($cuotaOld) || !is_numeric($cuotaNew)) throw new Exception("Datos ingresado no valido");			

			$cuotaOld=(int)$cuotaOld;
			$cuotaNew=(int)$cuotaNew;

			if(!is_numeric($cuotaOld) || !is_numeric($cuotaNew)) throw new Exception("Error validando cuotas ".$this->valorCuotaNew);
			
			//if($cuotaOld===$cuotaNew) throw new Exception("Cuotas Iguales");

			if($cuotaNew<0) throw new Exception("La cuota debe ser mayor a cero");
			
			//Se consultan productos
			$registros=$this->productosDisponibles();
			
			$Valores=$this->nodeApi->publicApi("/Productos/Ahorros",array("tipo"=>$tipoahorro),'GET');
			//var_dump($Valores[0][0]["valormaximo"]);
			$sumavalorminimo=($Valores[0][0]["valorminimo"]*2);
			if($cuotaNew<$Valores[0][0]["valorminimo"])throw new Exception("El valor de la cuota debe ser mayor o igual a $".number_format($sumavalorminimo));
			if($Valores[0][0]["valormaximo"]>0){
				if($cuotaNew>$Valores[0][0]["valormaximo"])throw new Exception("El valor de la cuota no puede superar $".number_format($Valores[0][0]["valormaximo"]));
			}

			//Producto a cambiar
			$productoCambiar=null;
			if($namelinea=='AHORRO MENSUAL'){
				foreach($registros as $key=>$val){
					//Se busca el producto para validar que efectivamente exista y validar el tiempo
					if(trim($registros[$key]["codlinea"])==$this->linea && trim($registros[$key]["numerocuenta"])==$this->nroCuenta ){
						$productoCambiar=$registros[$key];
						break;
					}
				}
			}
			else{
				foreach($registros as $key=>$val){
					//Se busca el producto para validar que efectivamente exista y validar el tiempo				
					if(trim($registros[$key]["codlinea"])==$this->linea && trim($registros[$key]["numerocuenta"])==$this->nroCuenta ){
						$productoCambiar=$registros[$key];
						break;
					}
				}
			}
			
			if(is_null($productoCambiar))throw new Exception("El producto no existe linea");
			
			if($productoCambiar["tiempoFaltante"]>0)
				throw new Exception("Para realizar un cambio de cuota al producto seleccionado deberá esperar hasta la fecha que allí se le muestra, según los lineamientos que se tienen establecidos por la entidad.");
			
			//Periodo de deduccion en días
			$periDeduccionDias=periodoDeduccionLetraADias($this->asociado->periododeduce);
			if(!is_numeric($periDeduccionDias))
				throw new Exception("No fue posible calcular el periodo de deducción ");

			//Se convierte la cuota ingresada a mensual teniendo en cuenta el periodo de deduccion
			$cuotaNew=($cuotaNew/$periDeduccionDias)*30;
			//var_dump($this->asociado->cedulasociado.'-'.trim($codlinea).'-'.$this->nroCuenta.'-'.$cuotaNew.'-'.$this->fechaActualizacion);
			
			$response=$this->nodeApi->privateApi("/Ahorro/CambioCuota",
						array("CedulaAsociado"=>$this->asociado->cedulasociado,"LineaAhorros"=>trim($codlinea),"Nrocuenta"=>$this->nroCuenta,
								"ValorCambioCuota"=>$cuotaNew,"FechaActualizacion"=>$this->fechaActualizacion),"POST");
			//var_dump($response);
			if(!is_array($response)) throw new Exception("No fue posible realizar el cambio de cuota por favor comuniquese con la entidad");

			$this->response=array("estado"=>true,"msj"=>"Cambio realizado correctamente");			

		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
		}
	}
	
	public function ahorrosParaDeshabilitar(){
		$respuesta=$this->nodeApi->privateApi("/Ahorro/ValidaUltimoCambioCuota",array("cedula"=>$this->asociado->cedulasociado),"GET");

		$vecTiempoFaltante=array();
		
		if($respuesta["name"]==="RequestError"){
			return array(array(),array());
		}		
		for($i=0;$i<count($respuesta);$i++){
			$vecTiempoFaltante[$i]=$respuesta[$i][0]["tiempofaltante"];
			$respuesta[$i]=array("codlinea"=>$respuesta[$i][0]["codlinea"],"numerocuenta"=>$respuesta[$i][0]["numerocuenta"]);			
		}		
		return array($respuesta,$vecTiempoFaltante);
	}


	public function tiposAhorrosPermitidos(){
		try{
			$respuesta=$this->nodeApi->privateApi("/Ahorro/tiposAhorrosPermitidos",array("cedula"=>$this->asociado->cedulasociado),"GET");
			
			if(is_null($respuesta)) throw new Exception("No fue posible consultar las tipos de ahorros disponibles");

			$this->response=array("estado"=>true,"msj"=>"Consulta de lineas ahorros correctamente");

			return $respuesta;
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
			return null;
		}
	}
	
	public function PorcentajeCambioAhorro($codlinea){
		try{
			$respuesta=$this->nodeApi->privateApi("/Ahorro/PorcentajesCambio",array("codlinea"=>$codlinea),"GET");
			
			if(is_null($respuesta)) throw new Exception("No fue posible consultar los porcentajes");

			$this->response=array("estado"=>true,"msj"=>"Consulta de porcentajes correctamente");

			return $respuesta;
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
			return null;
		}
	}
	
	public function LineasPermanentes(){
		try{
			$respuesta=$this->nodeApi->privateApi("/Ahorro/LineasPermanentes",array(),"GET");
			
			if(is_null($respuesta)) throw new Exception("No fue posible consultar los porcentajes");

			$this->response=array("estado"=>true,"msj"=>"Consulta de porcentajes correctamente");

			return $respuesta;
		}
		catch(Exception $e){
			$this->response=array("estado"=>false,"msj"=>$e->getMessage());
			return null;
		}
	}

	public function getResponse(){
		return $this->response;
	}
	
}
?>