<?php
require_once dirname(dirname(dirname(__FILE__)))."/modelo/NodeApi.php";
require_once dirname(dirname(dirname(__FILE__)))."/vendor/phpmailer/phpmailer/PHPMailerAutoload.php";
class Asociado{
	private $cedula;
	private $nodeApi;
	private $error;

	public function Asociado(){
		$this->cedula=$_SESSION["CEDULA"];
		$this->error="";
		$this->nodeApi=new NodeApi(false);
	}

	public function ConsultarInformacion(){		
		$result=$this->nodeApi->privateApi("/Asociado/ConsultarInformacion",array("cedula"=>$this->cedula),'GET');
		$aux=array();

		if(!is_null($result)){
			if(!isset($result["name"]) or $result["name"]!="RequestError"){
				$result=$result[0][0];
				
				foreach($result as $llave=>$valor){
					if(is_array($valor)){
						$valor=$valor[0];
					}
					$result[$llave]=trim($valor);
				}
				$aux=$result;
			}
			else{
				$aux=array("Error"=>"Error en la consulta de Informacion");
			}
		}
		else{
			$aux=array("Error"=>"Llamada mal estructurada de Informacion");
		}
		return $aux;
	}

	public function ConsultarReferencias(){
		$result=$this->nodeApi->privateApi("/ActuDatos/Referencias",array("cedula"=>$this->cedula),'GET');
		$aux=array();

		if(!is_null($result)){
			if(!isset($result["name"]) or $result["name"]!="RequestError"){
				$result=$result[0];
				$numReferencias=count($result);
				for($i=0;$i<$numReferencias;$i++){
					foreach($result[$i] as $llave=>$valor){
						if(is_array($valor)){
							$valor=$valor[0];
						}
						$result[$i][$llave]=trim($valor);
					}
				}

				$aux=$result;
			}
			else{
				$aux=array("Error"=>"Error en la consulta de Referencia");
			}
		}
		else{
			$aux=array("Error"=>"Llamada mal estructurada de Referencia");
		}
		return $aux;
	}
	
	public function ConsultarPersonasCargo(){
		$result=$this->nodeApi->privateApi("/ActuDatos/PersonasCargo",array("cedula"=>$this->cedula),'GET');
		$aux=array();

		if(!is_null($result)){
			if(!isset($result["name"]) or $result["name"]!="RequestError"){
				$result=$result[0];
				$numReferencias=count($result);
				for($i=0;$i<$numReferencias;$i++){
					foreach($result[$i] as $llave=>$valor){
						if(is_array($valor)){
							$valor=$valor[0];
						}
						$result[$i][$llave]=trim($valor);
					}
				}

				$aux=$result;
			}
			else{
				$aux=array("Error"=>"Error en la consulta de Personas a Cargo");
			}
		}
		else{
			$aux=array("Error"=>"Llamada mal estructurada de Personas a Cargo");
		}
		return $aux;
	}
	
	public function ActualizacionPendiente(){
		$result=$this->nodeApi->privateApi("/ActuDatos/ActualizacionPendiente",array("cedula"=>$this->cedula),'GET');
		if(!is_null($result)){
			if(!isset($result["name"]) or $result["name"]!="RequestError")
				if(count($result)>0)
					return true;
				else
					return false;
			else
				return false;
		}		
		return false;	
	}
	
	public function GuardarActualizacion($datos){
		$result=$this->nodeApi->privateApi("/ActuDatos/Guardar",$datos,'POST');
		
		if(!is_null($result)){
			if(!isset($result["name"]) or $result["name"]!="RequestError"){
				if(count($result)>0){
					return false;
				}
				else{
					return true;
				}
			}
			else{
				return false;
			}			
		}		
		return false;
	}
	
	public function correoConfirmacion(){
		$mail 		= new PHPMailer();
		$mensaje    = 
		'<html>
			<body>
				<table>
					<tr><th><strong>Actualizacion de datos<strong></th></tr>
					<tr>
						<td align="justify">El asociado(a) identificado(a) con CC '.$this->cedula.' acaba de realizar una actualizacion de datos 
							desde la página web por favor verificar en el Integrador S.F.C (OPA)
						</td>
					</tr>
				</table>
			</body>
		</html>
		';		
		try {
			$mail->FromName = "Administrador";
			$mail->IsSMTP();
			$mail->SMTPAuth = true;
			$mail->Host 	= "69.64.43.46"; 							
			$mail->Mailer   = "smtp";					
			$mail->Username = "noresponder@opa.com.co";			
			$mail->Password = "w3bm4st3r";						
			$mail->From 	= "noresponder@opa.com.co";
			
			$mail->AddAddress("opaweb@opa.com.co","prueba");
			//$mail->AddAddress("cesar_.28@hotmail.com","prueba");
			
			$mail->IsHTML(true); 								
			$mail->Subject = "Actualizacion de datos realizada desde la web";
			$mail->Body = $mensaje; 										
			$mail->Timeout = 10;
			/*echo "<pre>";
			var_dump($mail->Send());
			print_r($mail);
			echo "</pre>";
			exit;*/
			if($mail->Send()){
				return true;
			}
			return false;
		} 
		catch (Exception $e) {			
			return false;
		}		
	}
	
	public function getError(){
		return $this->error;
	}
}
?>