<?php
require_once dirname(dirname(dirname(__FILE__)))."/modelo/NodeApi.php";
require_once dirname(dirname(dirname(__FILE__)))."/vendor/autoload.php";//se debe de llamar este archivo ya que esta generalizado las secciones y nodeapi
//require_once dirname(dirname(dirname(__FILE__)))."/vendor/phpmailer/phpmailer/PHPMailerAutoload.php";
require_once dirname(dirname(__FILE__))."../../libreria/php/phpMailer/class.phpmailer.php";
class ActuDatos
{
	private $cedula;
	private $nodeApi;
	private $error;
	private $correoParametrizado;

	public function ActuDatos(){
		$this->cedula=$_SESSION["CEDULA"];
		$this->error="";
		$this->nodeApi=new NodeApi(false);
	}

	public function ConsultarInformacion(){		
		$result=$this->nodeApi->privateApi("/Asociado/ConsultarInformacion",array("cedula"=>$this->cedula),'GET');
		$aux=array();

		if(!is_null($result)){
			if(!isset($result["name"]) or $result["name"]!="RequestError"){
				$result=$result[0][0];
				
				foreach($result as $llave=>$valor){
					if(is_array($valor)){
						$valor=$valor[0];
					}
					$result[$llave]=trim($valor);
				}
				$aux=$result;
			}
			else{
				$aux=array("Error"=>"Error en la consulta de Informacion");
			}
		}
		else{
			$aux=array("Error"=>"Llamada mal estructurada de Informacion");
		}
		return $aux;
	}

	public function ConsultarOtraInformacion($caso){		
		$result=$this->nodeApi->privateApi("/Asociado/ConsultarOtraInformacionAsociado",array("cedula"=>$this->cedula,"caso"=>$caso),'GET');
		$aux=array();
		if(sizeof($result[0]) != 0 )
		{
			if(!is_null($result)){
				if(!isset($result["name"]) or $result["name"]!="RequestError"){
					$result=$result[0][0];
					
					foreach($result as $llave=>$valor){
						if(is_array($valor)){
							$valor=$valor[0];
						}
						$result[$llave]=trim($valor);
					}
					$aux=$result;
				}
				else{
					$aux=array("Error"=>"Error en la consulta de Informacion");
				}
			}
			else{
				$aux=array("Error"=>"Llamada mal estructurada de Informacion");
			}
			return $aux;
		}else{
			$aux=array("datos"=>"El asociado no tiene datos para el Caso '".$caso."'");
			return $aux;
		}
	}
	
	public function ConsulAutorizaciones($caso)
	{
		try{
			if ($caso==1) {
				$resultado=$this->nodeApi->privateApi("/ActuDatos/ConsultarAutorizaciones",array(),'GET');
				if(!$resultado) throw new Exception("Error consultando autorizaciones");
			}else if ($caso==2) {
				$resultado=$this->nodeApi->privateApi("/ActuDatos/ConsultaUltimaResAutorizacion",array("cedula"=>$this->cedula),'GET');
				if(!$resultado) throw new Exception("Error consultando las respuestas de autorizaciones");
			}
			
		}	
		catch(Exception $e)
		{
			$resultado=array("estado"=>false,"msj"=>$e->getMessage());

		}

		return $resultado;
	}

	public function GuardarAutorizaciones($datos)
	{
		try{
			$resultado=$this->nodeApi->privateApi("/ActuDatos/GuardarAutorizaciones",$datos,'POST');
			if(!$resultado) throw new Exception("Error Guardando Autorizaciones");
		}	
		catch(Exception $e)
		{
			$resultado=array("estado"=>false,"msj"=>$e->getMessage());

		}

		return $resultado;
	}

	public function ActualizacionPendiente(){
		$result=$this->nodeApi->privateApi("/ActuDatos/ActualizacionPendiente",array("cedula"=>$this->cedula),'GET');
		if(!is_null($result)){
			if(!isset($result["name"]) or $result["name"]!="RequestError")
				if(count($result)>0)
					return true;
				else
					return false;
			else
				return false;
		}		
		return false;	
	}
	
	public function GuardarActualizacion($datos){
		$result=$this->nodeApi->privateApi("/ActuDatos/GuardarActualizacion",$datos,'POST');
		
		if(!is_null($result)){
			if(!isset($result["name"]) or $result["name"]!="RequestError"){
				if(count($result)>0){
					return false;
				}
				else{
					return true;
				}
			}
			else{
				return false;
			}			
		}		
		return false;
	}
	
	public function correoConfirmacion(){

		$mesesparametrizados=$this->nodeApi->privateApi("/ActuDatos/ParametroActualizacion",array(),"GET");//se trae los meses parametrizados en el integrador
		$correo=$mesesparametrizados[0]["correo"];
		$this->correoParametrizado = $correo;

		$mail 		= new PHPMailer();
		$mensaje    = 
		'<html>
			<body>
				<table>
					<tr><th><strong>Actualizacion de datos<strong></th></tr>
					<tr>
						<td align="justify">El asociado(a) identificado(a) con CC '.$this->cedula.' acaba de realizar una actualizaci&oacute;n de datos 
							desde la p&aacute;gina web por favor verificar en el Integrador S.F.C (OPA)
						</td>
					</tr>
				</table>
			</body>
		</html>
		';		
		try {
			$mail->Mailer   = "smtp";
			$mail->Host 	= "mail.opa.com.co";
			$mail->Username = "noresponder@opa.com.co";			
			$mail->Password = "w3bm4st3r";						
			$mail->From 	= "noresponder@cooeban.com.co";
			$mail->FromName = "Administrador";
			$mail->IsSMTP();
			$mail->SMTPAuth = true;
			$mail->AddAddress($this->correoParametrizado,"Actualizacion");
			//$mail->AddAddress("cesar_.28@hotmail.com","prueba");
			
			$mail->IsHTML(true); 								
			$mail->Subject = "Actualizacion de datos realizada desde la web";
			$mail->Body = $mensaje; 										
			$mail->Timeout = 10;
			/*echo "<pre>";
			var_dump($mail->Send());
			print_r($mail);
			echo "</pre>";
			exit;*/
			if($mail->Send()){
				return true;
			}
			return false;
		} 
		catch (Exception $e) {			
			return false;
		}		
	}
	
	public function getError(){
		return $this->error;
	}

	//obtener el navegador del usuario
	public function getBrowser($user_agent){
		if(strpos($user_agent, 'MSIE') !== FALSE)
		   return 'Internet explorer';
		 elseif(strpos($user_agent, 'Edge') !== FALSE) //Microsoft Edge
		   return 'Microsoft Edge';
		 elseif(strpos($user_agent, 'Trident') !== FALSE) //IE 11
		    return 'Internet explorer';
		 elseif(strpos($user_agent, 'Opera Mini') !== FALSE)
		   return "Opera Mini";
		 elseif(strpos($user_agent, 'Opera') || strpos($user_agent, 'OPR') !== FALSE)
		   return "Opera";
		 elseif(strpos($user_agent, 'Firefox') !== FALSE)
		   return 'Mozilla Firefox';
		 elseif(strpos($user_agent, 'Chrome') !== FALSE)
		   return 'Google Chrome';
		 elseif(strpos($user_agent, 'Safari') !== FALSE)
		   return "Safari";
		 else
		   return 'No hemos podido detectar su navegador';

	}

	//Obtiene la IP del cliente
	public function get_client_ip() {
        $ipaddress = '';
        if (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if(getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if(getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if(getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if(getenv('HTTP_FORWARDED'))
           $ipaddress = getenv('HTTP_FORWARDED');
        else if(getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }

    public function ConsulBienes(){
    	try{
			$resultadoVehiculos=$this->nodeApi->privateApi("/Asociado/BienesVehiculo",array("cedula"=>$this->cedula),'GET');

			$resultadoRaiz=$this->nodeApi->privateApi("/Asociado/BienesRaiz",array("cedula"=>$this->cedula),'GET');

			$resultado=array(	
								"Vehiculo"=>$resultadoVehiculos,
								"Raiz"=>$resultadoRaiz
							);

			if(!$resultado) throw new Exception("Error consultando autorizaciones");
		}	
		catch(Exception $e)
		{
			$resultado=array("estado"=>false,"msj"=>$e->getMessage());

		}

		return $resultado;
    }
}
?>